/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkloadIdentityResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetWorkloadIdentityResponse.Builder, GetWorkloadIdentityResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkloadIdentityResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> WORKLOAD_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadIdentityArn").getter(getter(GetWorkloadIdentityResponse::workloadIdentityArn))
            .setter(setter(Builder::workloadIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityArn").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResourceOauth2ReturnUrls")
            .getter(getter(GetWorkloadIdentityResponse::allowedResourceOauth2ReturnUrls))
            .setter(setter(Builder::allowedResourceOauth2ReturnUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResourceOauth2ReturnUrls")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(GetWorkloadIdentityResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(GetWorkloadIdentityResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            WORKLOAD_IDENTITY_ARN_FIELD, ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String workloadIdentityArn;

    private final List<String> allowedResourceOauth2ReturnUrls;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private GetWorkloadIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.workloadIdentityArn = builder.workloadIdentityArn;
        this.allowedResourceOauth2ReturnUrls = builder.allowedResourceOauth2ReturnUrls;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the workload identity.
     * </p>
     * 
     * @return The name of the workload identity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workload identity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workload identity.
     */
    public final String workloadIdentityArn() {
        return workloadIdentityArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResourceOauth2ReturnUrls
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAllowedResourceOauth2ReturnUrls() {
        return allowedResourceOauth2ReturnUrls != null && !(allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of allowed OAuth2 return URLs for resources associated with this workload identity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResourceOauth2ReturnUrls}
     * method.
     * </p>
     * 
     * @return The list of allowed OAuth2 return URLs for resources associated with this workload identity.
     */
    public final List<String> allowedResourceOauth2ReturnUrls() {
        return allowedResourceOauth2ReturnUrls;
    }

    /**
     * <p>
     * The timestamp when the workload identity was created.
     * </p>
     * 
     * @return The timestamp when the workload identity was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp when the workload identity was last updated.
     * </p>
     * 
     * @return The timestamp when the workload identity was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAllowedResourceOauth2ReturnUrls() ? allowedResourceOauth2ReturnUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkloadIdentityResponse)) {
            return false;
        }
        GetWorkloadIdentityResponse other = (GetWorkloadIdentityResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(workloadIdentityArn(), other.workloadIdentityArn())
                && hasAllowedResourceOauth2ReturnUrls() == other.hasAllowedResourceOauth2ReturnUrls()
                && Objects.equals(allowedResourceOauth2ReturnUrls(), other.allowedResourceOauth2ReturnUrls())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetWorkloadIdentityResponse")
                .add("Name", name())
                .add("WorkloadIdentityArn", workloadIdentityArn())
                .add("AllowedResourceOauth2ReturnUrls",
                        hasAllowedResourceOauth2ReturnUrls() ? allowedResourceOauth2ReturnUrls() : null)
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "workloadIdentityArn":
            return Optional.ofNullable(clazz.cast(workloadIdentityArn()));
        case "allowedResourceOauth2ReturnUrls":
            return Optional.ofNullable(clazz.cast(allowedResourceOauth2ReturnUrls()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("workloadIdentityArn", WORKLOAD_IDENTITY_ARN_FIELD);
        map.put("allowedResourceOauth2ReturnUrls", ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkloadIdentityResponse, T> g) {
        return obj -> g.apply((GetWorkloadIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkloadIdentityResponse> {
        /**
         * <p>
         * The name of the workload identity.
         * </p>
         * 
         * @param name
         *        The name of the workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workload identity.
         * </p>
         * 
         * @param workloadIdentityArn
         *        The Amazon Resource Name (ARN) of the workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityArn(String workloadIdentityArn);

        /**
         * <p>
         * The list of allowed OAuth2 return URLs for resources associated with this workload identity.
         * </p>
         * 
         * @param allowedResourceOauth2ReturnUrls
         *        The list of allowed OAuth2 return URLs for resources associated with this workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls);

        /**
         * <p>
         * The list of allowed OAuth2 return URLs for resources associated with this workload identity.
         * </p>
         * 
         * @param allowedResourceOauth2ReturnUrls
         *        The list of allowed OAuth2 return URLs for resources associated with this workload identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResourceOauth2ReturnUrls(String... allowedResourceOauth2ReturnUrls);

        /**
         * <p>
         * The timestamp when the workload identity was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the workload identity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp when the workload identity was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the workload identity was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String name;

        private String workloadIdentityArn;

        private List<String> allowedResourceOauth2ReturnUrls = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkloadIdentityResponse model) {
            super(model);
            name(model.name);
            workloadIdentityArn(model.workloadIdentityArn);
            allowedResourceOauth2ReturnUrls(model.allowedResourceOauth2ReturnUrls);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkloadIdentityArn() {
            return workloadIdentityArn;
        }

        public final void setWorkloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
        }

        @Override
        public final Builder workloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
            return this;
        }

        public final Collection<String> getAllowedResourceOauth2ReturnUrls() {
            if (allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResourceOauth2ReturnUrls;
        }

        public final void setAllowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
        }

        @Override
        public final Builder allowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResourceOauth2ReturnUrls(String... allowedResourceOauth2ReturnUrls) {
            allowedResourceOauth2ReturnUrls(Arrays.asList(allowedResourceOauth2ReturnUrls));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public GetWorkloadIdentityResponse build() {
            return new GetWorkloadIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
