/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBrowserResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetBrowserResponse.Builder, GetBrowserResponse> {
    private static final SdkField<String> BROWSER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserId").getter(getter(GetBrowserResponse::browserId)).setter(setter(Builder::browserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserId").build()).build();

    private static final SdkField<String> BROWSER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserArn").getter(getter(GetBrowserResponse::browserArn)).setter(setter(Builder::browserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBrowserResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetBrowserResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetBrowserResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<BrowserNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<BrowserNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(GetBrowserResponse::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(BrowserNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<RecordingConfig> RECORDING_FIELD = SdkField.<RecordingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("recording").getter(getter(GetBrowserResponse::recording)).setter(setter(Builder::recording))
            .constructor(RecordingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetBrowserResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetBrowserResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetBrowserResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_ID_FIELD,
            BROWSER_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD,
            RECORDING_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserId;

    private final String browserArn;

    private final String name;

    private final String description;

    private final String executionRoleArn;

    private final BrowserNetworkConfiguration networkConfiguration;

    private final RecordingConfig recording;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private GetBrowserResponse(BuilderImpl builder) {
        super(builder);
        this.browserId = builder.browserId;
        this.browserArn = builder.browserArn;
        this.name = builder.name;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.recording = builder.recording;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The unique identifier of the browser.
     * </p>
     * 
     * @return The unique identifier of the browser.
     */
    public final String browserId() {
        return browserId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the browser.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the browser.
     */
    public final String browserArn() {
        return browserArn;
    }

    /**
     * <p>
     * The name of the browser.
     * </p>
     * 
     * @return The name of the browser.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the browser.
     * </p>
     * 
     * @return The description of the browser.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role ARN that provides permissions for the browser.
     * </p>
     * 
     * @return The IAM role ARN that provides permissions for the browser.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * Returns the value of the NetworkConfiguration property for this object.
     * 
     * @return The value of the NetworkConfiguration property for this object.
     */
    public final BrowserNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * Returns the value of the Recording property for this object.
     * 
     * @return The value of the Recording property for this object.
     */
    public final RecordingConfig recording() {
        return recording;
    }

    /**
     * <p>
     * The current status of the browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser.
     * @see BrowserStatus
     */
    public final BrowserStatus status() {
        return BrowserStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser.
     * @see BrowserStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the browser was created.
     * </p>
     * 
     * @return The timestamp when the browser was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the browser was last updated.
     * </p>
     * 
     * @return The timestamp when the browser was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserId());
        hashCode = 31 * hashCode + Objects.hashCode(browserArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(recording());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBrowserResponse)) {
            return false;
        }
        GetBrowserResponse other = (GetBrowserResponse) obj;
        return Objects.equals(browserId(), other.browserId()) && Objects.equals(browserArn(), other.browserArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(recording(), other.recording()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBrowserResponse").add("BrowserId", browserId()).add("BrowserArn", browserArn())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExecutionRoleArn", executionRoleArn()).add("NetworkConfiguration", networkConfiguration())
                .add("Recording", recording()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserId":
            return Optional.ofNullable(clazz.cast(browserId()));
        case "browserArn":
            return Optional.ofNullable(clazz.cast(browserArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "recording":
            return Optional.ofNullable(clazz.cast(recording()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserId", BROWSER_ID_FIELD);
        map.put("browserArn", BROWSER_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("recording", RECORDING_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBrowserResponse, T> g) {
        return obj -> g.apply((GetBrowserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBrowserResponse> {
        /**
         * <p>
         * The unique identifier of the browser.
         * </p>
         * 
         * @param browserId
         *        The unique identifier of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserId(String browserId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the browser.
         * </p>
         * 
         * @param browserArn
         *        The Amazon Resource Name (ARN) of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserArn(String browserArn);

        /**
         * <p>
         * The name of the browser.
         * </p>
         * 
         * @param name
         *        The name of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the browser.
         * </p>
         * 
         * @param description
         *        The description of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role ARN that provides permissions for the browser.
         * </p>
         * 
         * @param executionRoleArn
         *        The IAM role ARN that provides permissions for the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * @param networkConfiguration
         *        The new value for the NetworkConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(BrowserNetworkConfiguration networkConfiguration);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BrowserNetworkConfiguration.Builder}
         * avoiding the need to create one manually via {@link BrowserNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #networkConfiguration(BrowserNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link BrowserNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(BrowserNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<BrowserNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(BrowserNetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * Sets the value of the Recording property for this object.
         *
         * @param recording
         *        The new value for the Recording property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recording(RecordingConfig recording);

        /**
         * Sets the value of the Recording property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RecordingConfig.Builder} avoiding the
         * need to create one manually via {@link RecordingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recording(RecordingConfig)}.
         * 
         * @param recording
         *        a consumer that will call methods on {@link RecordingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recording(RecordingConfig)
         */
        default Builder recording(Consumer<RecordingConfig.Builder> recording) {
            return recording(RecordingConfig.builder().applyMutation(recording).build());
        }

        /**
         * <p>
         * The current status of the browser.
         * </p>
         * 
         * @param status
         *        The current status of the browser.
         * @see BrowserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the browser.
         * </p>
         * 
         * @param status
         *        The current status of the browser.
         * @see BrowserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserStatus
         */
        Builder status(BrowserStatus status);

        /**
         * <p>
         * The timestamp when the browser was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the browser was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the browser was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the browser was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String browserId;

        private String browserArn;

        private String name;

        private String description;

        private String executionRoleArn;

        private BrowserNetworkConfiguration networkConfiguration;

        private RecordingConfig recording;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBrowserResponse model) {
            super(model);
            browserId(model.browserId);
            browserArn(model.browserArn);
            name(model.name);
            description(model.description);
            executionRoleArn(model.executionRoleArn);
            networkConfiguration(model.networkConfiguration);
            recording(model.recording);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserId() {
            return browserId;
        }

        public final void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        @Override
        public final Builder browserId(String browserId) {
            this.browserId = browserId;
            return this;
        }

        public final String getBrowserArn() {
            return browserArn;
        }

        public final void setBrowserArn(String browserArn) {
            this.browserArn = browserArn;
        }

        @Override
        public final Builder browserArn(String browserArn) {
            this.browserArn = browserArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final BrowserNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(BrowserNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(BrowserNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final RecordingConfig.Builder getRecording() {
            return recording != null ? recording.toBuilder() : null;
        }

        public final void setRecording(RecordingConfig.BuilderImpl recording) {
            this.recording = recording != null ? recording.build() : null;
        }

        @Override
        public final Builder recording(RecordingConfig recording) {
            this.recording = recording;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetBrowserResponse build() {
            return new GetBrowserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
