/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentRuntimeResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetAgentRuntimeResponse.Builder, GetAgentRuntimeResponse> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(GetAgentRuntimeResponse::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<WorkloadIdentityDetails> WORKLOAD_IDENTITY_DETAILS_FIELD = SdkField
            .<WorkloadIdentityDetails> builder(MarshallingType.SDK_POJO).memberName("workloadIdentityDetails")
            .getter(getter(GetAgentRuntimeResponse::workloadIdentityDetails)).setter(setter(Builder::workloadIdentityDetails))
            .constructor(WorkloadIdentityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityDetails").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeName").getter(getter(GetAgentRuntimeResponse::agentRuntimeName))
            .setter(setter(Builder::agentRuntimeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAgentRuntimeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(GetAgentRuntimeResponse::agentRuntimeId))
            .setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeVersion").getter(getter(GetAgentRuntimeResponse::agentRuntimeVersion))
            .setter(setter(Builder::agentRuntimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAgentRuntimeResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetAgentRuntimeResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetAgentRuntimeResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<AgentArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField
            .<AgentArtifact> builder(MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact")
            .getter(getter(GetAgentRuntimeResponse::agentRuntimeArtifact)).setter(setter(Builder::agentRuntimeArtifact))
            .constructor(AgentArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(GetAgentRuntimeResponse::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField
            .<ProtocolConfiguration> builder(MarshallingType.SDK_POJO).memberName("protocolConfiguration")
            .getter(getter(GetAgentRuntimeResponse::protocolConfiguration)).setter(setter(Builder::protocolConfiguration))
            .constructor(ProtocolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(GetAgentRuntimeResponse::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField
            .<AuthorizerConfiguration> builder(MarshallingType.SDK_POJO).memberName("authorizerConfiguration")
            .getter(getter(GetAgentRuntimeResponse::authorizerConfiguration)).setter(setter(Builder::authorizerConfiguration))
            .constructor(AuthorizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAgentRuntimeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD,
            WORKLOAD_IDENTITY_DETAILS_FIELD, AGENT_RUNTIME_NAME_FIELD, DESCRIPTION_FIELD, AGENT_RUNTIME_ID_FIELD,
            AGENT_RUNTIME_VERSION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ROLE_ARN_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD,
            NETWORK_CONFIGURATION_FIELD, PROTOCOL_CONFIGURATION_FIELD, ENVIRONMENT_VARIABLES_FIELD,
            AUTHORIZER_CONFIGURATION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeArn;

    private final WorkloadIdentityDetails workloadIdentityDetails;

    private final String agentRuntimeName;

    private final String description;

    private final String agentRuntimeId;

    private final String agentRuntimeVersion;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String roleArn;

    private final AgentArtifact agentRuntimeArtifact;

    private final NetworkConfiguration networkConfiguration;

    private final ProtocolConfiguration protocolConfiguration;

    private final Map<String, String> environmentVariables;

    private final AuthorizerConfiguration authorizerConfiguration;

    private final String status;

    private GetAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.workloadIdentityDetails = builder.workloadIdentityDetails;
        this.agentRuntimeName = builder.agentRuntimeName;
        this.description = builder.description;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.roleArn = builder.roleArn;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.networkConfiguration = builder.networkConfiguration;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.environmentVariables = builder.environmentVariables;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The workload identity details for the agent runtime.
     * </p>
     * 
     * @return The workload identity details for the agent runtime.
     */
    public final WorkloadIdentityDetails workloadIdentityDetails() {
        return workloadIdentityDetails;
    }

    /**
     * <p>
     * The name of the agent runtime.
     * </p>
     * 
     * @return The name of the agent runtime.
     */
    public final String agentRuntimeName() {
        return agentRuntimeName;
    }

    /**
     * <p>
     * The description of the agent runtime.
     * </p>
     * 
     * @return The description of the agent runtime.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime.
     * </p>
     * 
     * @return The unique identifier of the agent runtime.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The version of the agent runtime.
     * </p>
     * 
     * @return The version of the agent runtime.
     */
    public final String agentRuntimeVersion() {
        return agentRuntimeVersion;
    }

    /**
     * <p>
     * The timestamp when the agent runtime was created.
     * </p>
     * 
     * @return The timestamp when the agent runtime was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the agent runtime was last updated.
     * </p>
     * 
     * @return The timestamp when the agent runtime was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The IAM role ARN that provides permissions for the agent runtime.
     * </p>
     * 
     * @return The IAM role ARN that provides permissions for the agent runtime.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The artifact of the agent runtime.
     * </p>
     * 
     * @return The artifact of the agent runtime.
     */
    public final AgentArtifact agentRuntimeArtifact() {
        return agentRuntimeArtifact;
    }

    /**
     * <p>
     * The network configuration for the agent runtime.
     * </p>
     * 
     * @return The network configuration for the agent runtime.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * Returns the value of the ProtocolConfiguration property for this object.
     * 
     * @return The value of the ProtocolConfiguration property for this object.
     */
    public final ProtocolConfiguration protocolConfiguration() {
        return protocolConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Environment variables set in the agent runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return Environment variables set in the agent runtime environment.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The authorizer configuration for the agent runtime.
     * </p>
     * 
     * @return The authorizer configuration for the agent runtime.
     */
    public final AuthorizerConfiguration authorizerConfiguration() {
        return authorizerConfiguration;
    }

    /**
     * <p>
     * The current status of the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentRuntimeResponse)) {
            return false;
        }
        GetAgentRuntimeResponse other = (GetAgentRuntimeResponse) obj;
        return Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(workloadIdentityDetails(), other.workloadIdentityDetails())
                && Objects.equals(agentRuntimeName(), other.agentRuntimeName())
                && Objects.equals(description(), other.description()) && Objects.equals(agentRuntimeId(), other.agentRuntimeId())
                && Objects.equals(agentRuntimeVersion(), other.agentRuntimeVersion())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(agentRuntimeArtifact(), other.agentRuntimeArtifact())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(protocolConfiguration(), other.protocolConfiguration())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(authorizerConfiguration(), other.authorizerConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentRuntimeResponse").add("AgentRuntimeArn", agentRuntimeArn())
                .add("WorkloadIdentityDetails", workloadIdentityDetails()).add("AgentRuntimeName", agentRuntimeName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AgentRuntimeId", agentRuntimeId()).add("AgentRuntimeVersion", agentRuntimeVersion())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("RoleArn", roleArn())
                .add("AgentRuntimeArtifact", agentRuntimeArtifact()).add("NetworkConfiguration", networkConfiguration())
                .add("ProtocolConfiguration", protocolConfiguration())
                .add("EnvironmentVariables", environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthorizerConfiguration", authorizerConfiguration()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "workloadIdentityDetails":
            return Optional.ofNullable(clazz.cast(workloadIdentityDetails()));
        case "agentRuntimeName":
            return Optional.ofNullable(clazz.cast(agentRuntimeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "agentRuntimeVersion":
            return Optional.ofNullable(clazz.cast(agentRuntimeVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "agentRuntimeArtifact":
            return Optional.ofNullable(clazz.cast(agentRuntimeArtifact()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "protocolConfiguration":
            return Optional.ofNullable(clazz.cast(protocolConfiguration()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "authorizerConfiguration":
            return Optional.ofNullable(clazz.cast(authorizerConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("workloadIdentityDetails", WORKLOAD_IDENTITY_DETAILS_FIELD);
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentRuntimeResponse, T> g) {
        return obj -> g.apply((GetAgentRuntimeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentRuntimeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The workload identity details for the agent runtime.
         * </p>
         * 
         * @param workloadIdentityDetails
         *        The workload identity details for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails);

        /**
         * <p>
         * The workload identity details for the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadIdentityDetails.Builder} avoiding
         * the need to create one manually via {@link WorkloadIdentityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadIdentityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #workloadIdentityDetails(WorkloadIdentityDetails)}.
         * 
         * @param workloadIdentityDetails
         *        a consumer that will call methods on {@link WorkloadIdentityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadIdentityDetails(WorkloadIdentityDetails)
         */
        default Builder workloadIdentityDetails(Consumer<WorkloadIdentityDetails.Builder> workloadIdentityDetails) {
            return workloadIdentityDetails(WorkloadIdentityDetails.builder().applyMutation(workloadIdentityDetails).build());
        }

        /**
         * <p>
         * The name of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeName
         *        The name of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeName(String agentRuntimeName);

        /**
         * <p>
         * The description of the agent runtime.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The version of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeVersion
         *        The version of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeVersion(String agentRuntimeVersion);

        /**
         * <p>
         * The timestamp when the agent runtime was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the agent runtime was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the agent runtime was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the agent runtime was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The IAM role ARN that provides permissions for the agent runtime.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that provides permissions for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The artifact of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeArtifact
         *        The artifact of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArtifact(AgentArtifact agentRuntimeArtifact);

        /**
         * <p>
         * The artifact of the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentArtifact.Builder} avoiding the need
         * to create one manually via {@link AgentArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentArtifact.Builder#build()} is called immediately and its
         * result is passed to {@link #agentRuntimeArtifact(AgentArtifact)}.
         * 
         * @param agentRuntimeArtifact
         *        a consumer that will call methods on {@link AgentArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentRuntimeArtifact(AgentArtifact)
         */
        default Builder agentRuntimeArtifact(Consumer<AgentArtifact.Builder> agentRuntimeArtifact) {
            return agentRuntimeArtifact(AgentArtifact.builder().applyMutation(agentRuntimeArtifact).build());
        }

        /**
         * <p>
         * The network configuration for the agent runtime.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * @param protocolConfiguration
         *        The new value for the ProtocolConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProtocolConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtocolConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #protocolConfiguration(ProtocolConfiguration)}.
         * 
         * @param protocolConfiguration
         *        a consumer that will call methods on {@link ProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfiguration(ProtocolConfiguration)
         */
        default Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return protocolConfiguration(ProtocolConfiguration.builder().applyMutation(protocolConfiguration).build());
        }

        /**
         * <p>
         * Environment variables set in the agent runtime environment.
         * </p>
         * 
         * @param environmentVariables
         *        Environment variables set in the agent runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The authorizer configuration for the agent runtime.
         * </p>
         * 
         * @param authorizerConfiguration
         *        The authorizer configuration for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration);

        /**
         * <p>
         * The authorizer configuration for the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AuthorizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizerConfiguration(AuthorizerConfiguration)}.
         * 
         * @param authorizerConfiguration
         *        a consumer that will call methods on {@link AuthorizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfiguration(AuthorizerConfiguration)
         */
        default Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return authorizerConfiguration(AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration).build());
        }

        /**
         * <p>
         * The current status of the agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String agentRuntimeArn;

        private WorkloadIdentityDetails workloadIdentityDetails;

        private String agentRuntimeName;

        private String description;

        private String agentRuntimeId;

        private String agentRuntimeVersion;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String roleArn;

        private AgentArtifact agentRuntimeArtifact;

        private NetworkConfiguration networkConfiguration;

        private ProtocolConfiguration protocolConfiguration;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private AuthorizerConfiguration authorizerConfiguration;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentRuntimeResponse model) {
            super(model);
            agentRuntimeArn(model.agentRuntimeArn);
            workloadIdentityDetails(model.workloadIdentityDetails);
            agentRuntimeName(model.agentRuntimeName);
            description(model.description);
            agentRuntimeId(model.agentRuntimeId);
            agentRuntimeVersion(model.agentRuntimeVersion);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            roleArn(model.roleArn);
            agentRuntimeArtifact(model.agentRuntimeArtifact);
            networkConfiguration(model.networkConfiguration);
            protocolConfiguration(model.protocolConfiguration);
            environmentVariables(model.environmentVariables);
            authorizerConfiguration(model.authorizerConfiguration);
            status(model.status);
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final WorkloadIdentityDetails.Builder getWorkloadIdentityDetails() {
            return workloadIdentityDetails != null ? workloadIdentityDetails.toBuilder() : null;
        }

        public final void setWorkloadIdentityDetails(WorkloadIdentityDetails.BuilderImpl workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails != null ? workloadIdentityDetails.build() : null;
        }

        @Override
        public final Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails;
            return this;
        }

        public final String getAgentRuntimeName() {
            return agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AgentArtifact.Builder getAgentRuntimeArtifact() {
            return agentRuntimeArtifact != null ? agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return protocolConfiguration != null ? protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return authorizerConfiguration != null ? authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAgentRuntimeResponse build() {
            return new GetAgentRuntimeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
