/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentRuntimeRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<GetAgentRuntimeRequest.Builder, GetAgentRuntimeRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(GetAgentRuntimeRequest::agentRuntimeId))
            .setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeVersion").getter(getter(GetAgentRuntimeRequest::agentRuntimeVersion))
            .setter(setter(Builder::agentRuntimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD,
            AGENT_RUNTIME_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeId;

    private final String agentRuntimeVersion;

    private GetAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime to retrieve.
     * </p>
     * 
     * @return The unique identifier of the agent runtime to retrieve.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The version of the agent runtime to retrieve.
     * </p>
     * 
     * @return The version of the agent runtime to retrieve.
     */
    public final String agentRuntimeVersion() {
        return agentRuntimeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentRuntimeRequest)) {
            return false;
        }
        GetAgentRuntimeRequest other = (GetAgentRuntimeRequest) obj;
        return Objects.equals(agentRuntimeId(), other.agentRuntimeId())
                && Objects.equals(agentRuntimeVersion(), other.agentRuntimeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentRuntimeRequest").add("AgentRuntimeId", agentRuntimeId())
                .add("AgentRuntimeVersion", agentRuntimeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "agentRuntimeVersion":
            return Optional.ofNullable(clazz.cast(agentRuntimeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("version", AGENT_RUNTIME_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentRuntimeRequest, T> g) {
        return obj -> g.apply((GetAgentRuntimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentRuntimeRequest> {
        /**
         * <p>
         * The unique identifier of the agent runtime to retrieve.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the agent runtime to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The version of the agent runtime to retrieve.
         * </p>
         * 
         * @param agentRuntimeVersion
         *        The version of the agent runtime to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeVersion(String agentRuntimeVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String agentRuntimeId;

        private String agentRuntimeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentRuntimeRequest model) {
            super(model);
            agentRuntimeId(model.agentRuntimeId);
            agentRuntimeVersion(model.agentRuntimeVersion);
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAgentRuntimeRequest build() {
            return new GetAgentRuntimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
