/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentRuntimeEndpointResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetAgentRuntimeEndpointResponse.Builder, GetAgentRuntimeEndpointResponse> {
    private static final SdkField<String> LIVE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("liveVersion").getter(getter(GetAgentRuntimeEndpointResponse::liveVersion))
            .setter(setter(Builder::liveVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveVersion").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetVersion").getter(getter(GetAgentRuntimeEndpointResponse::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeEndpointArn").getter(getter(GetAgentRuntimeEndpointResponse::agentRuntimeEndpointArn))
            .setter(setter(Builder::agentRuntimeEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(GetAgentRuntimeEndpointResponse::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAgentRuntimeEndpointResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAgentRuntimeEndpointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAgentRuntimeEndpointResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetAgentRuntimeEndpointResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetAgentRuntimeEndpointResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAgentRuntimeEndpointResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAgentRuntimeEndpointResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_VERSION_FIELD,
            TARGET_VERSION_FIELD, AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_REASON_FIELD, NAME_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String liveVersion;

    private final String targetVersion;

    private final String agentRuntimeEndpointArn;

    private final String agentRuntimeArn;

    private final String description;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String failureReason;

    private final String name;

    private final String id;

    private GetAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.liveVersion = builder.liveVersion;
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.description = builder.description;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureReason = builder.failureReason;
        this.name = builder.name;
        this.id = builder.id;
    }

    /**
     * <p>
     * The currently deployed version of the agent runtime on the endpoint.
     * </p>
     * 
     * @return The currently deployed version of the agent runtime on the endpoint.
     */
    public final String liveVersion() {
        return liveVersion;
    }

    /**
     * <p>
     * The target version of the agent runtime for the endpoint.
     * </p>
     * 
     * @return The target version of the agent runtime for the endpoint.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime endpoint.
     */
    public final String agentRuntimeEndpointArn() {
        return agentRuntimeEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The description of the agent runtime endpoint.
     * </p>
     * 
     * @return The description of the agent runtime endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final AgentEndpointStatus status() {
        return AgentEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the agent runtime endpoint was created.
     * </p>
     * 
     * @return The timestamp when the agent runtime endpoint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the agent runtime endpoint was last updated.
     * </p>
     * 
     * @return The timestamp when the agent runtime endpoint was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The reason for failure if the agent runtime endpoint is in a failed state.
     * </p>
     * 
     * @return The reason for failure if the agent runtime endpoint is in a failed state.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name of the agent runtime endpoint.
     * </p>
     * 
     * @return The name of the agent runtime endpoint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime endpoint.
     * </p>
     * 
     * @return The unique identifier of the agent runtime endpoint.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(liveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentRuntimeEndpointResponse)) {
            return false;
        }
        GetAgentRuntimeEndpointResponse other = (GetAgentRuntimeEndpointResponse) obj;
        return Objects.equals(liveVersion(), other.liveVersion()) && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn())
                && Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(name(), other.name())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentRuntimeEndpointResponse").add("LiveVersion", liveVersion())
                .add("TargetVersion", targetVersion()).add("AgentRuntimeEndpointArn", agentRuntimeEndpointArn())
                .add("AgentRuntimeArn", agentRuntimeArn()).add("Description", description()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("FailureReason", failureReason())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "liveVersion":
            return Optional.ofNullable(clazz.cast(liveVersion()));
        case "targetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "agentRuntimeEndpointArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeEndpointArn()));
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("liveVersion", LIVE_VERSION_FIELD);
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((GetAgentRuntimeEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentRuntimeEndpointResponse> {
        /**
         * <p>
         * The currently deployed version of the agent runtime on the endpoint.
         * </p>
         * 
         * @param liveVersion
         *        The currently deployed version of the agent runtime on the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveVersion(String liveVersion);

        /**
         * <p>
         * The target version of the agent runtime for the endpoint.
         * </p>
         * 
         * @param targetVersion
         *        The target version of the agent runtime for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * </p>
         * 
         * @param agentRuntimeEndpointArn
         *        The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The description of the agent runtime endpoint.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(AgentEndpointStatus status);

        /**
         * <p>
         * The timestamp when the agent runtime endpoint was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the agent runtime endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the agent runtime endpoint was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the agent runtime endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The reason for failure if the agent runtime endpoint is in a failed state.
         * </p>
         * 
         * @param failureReason
         *        The reason for failure if the agent runtime endpoint is in a failed state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name of the agent runtime endpoint.
         * </p>
         * 
         * @param name
         *        The name of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the agent runtime endpoint.
         * </p>
         * 
         * @param id
         *        The unique identifier of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String liveVersion;

        private String targetVersion;

        private String agentRuntimeEndpointArn;

        private String agentRuntimeArn;

        private String description;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String failureReason;

        private String name;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentRuntimeEndpointResponse model) {
            super(model);
            liveVersion(model.liveVersion);
            targetVersion(model.targetVersion);
            agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            agentRuntimeArn(model.agentRuntimeArn);
            description(model.description);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            failureReason(model.failureReason);
            name(model.name);
            id(model.id);
        }

        public final String getLiveVersion() {
            return liveVersion;
        }

        public final void setLiveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
        }

        @Override
        public final Builder liveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetAgentRuntimeEndpointResponse build() {
            return new GetAgentRuntimeEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
