/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for a custom consolidation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConsolidationConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConsolidationConfigurationInput.Builder, CustomConsolidationConfigurationInput> {
    private static final SdkField<SemanticOverrideConsolidationConfigurationInput> SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<SemanticOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("semanticConsolidationOverride")
            .getter(getter(CustomConsolidationConfigurationInput::semanticConsolidationOverride))
            .setter(setter(Builder::semanticConsolidationOverride))
            .constructor(SemanticOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticConsolidationOverride")
                    .build()).build();

    private static final SdkField<SummaryOverrideConsolidationConfigurationInput> SUMMARY_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<SummaryOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("summaryConsolidationOverride")
            .getter(getter(CustomConsolidationConfigurationInput::summaryConsolidationOverride))
            .setter(setter(Builder::summaryConsolidationOverride))
            .constructor(SummaryOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryConsolidationOverride")
                    .build()).build();

    private static final SdkField<UserPreferenceOverrideConsolidationConfigurationInput> USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<UserPreferenceOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("userPreferenceConsolidationOverride")
            .getter(getter(CustomConsolidationConfigurationInput::userPreferenceConsolidationOverride))
            .setter(setter(Builder::userPreferenceConsolidationOverride))
            .constructor(UserPreferenceOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("userPreferenceConsolidationOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD, SUMMARY_CONSOLIDATION_OVERRIDE_FIELD,
            USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride;

    private final SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride;

    private final UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride;

    private final Type type;

    private CustomConsolidationConfigurationInput(BuilderImpl builder) {
        this.semanticConsolidationOverride = builder.semanticConsolidationOverride;
        this.summaryConsolidationOverride = builder.summaryConsolidationOverride;
        this.userPreferenceConsolidationOverride = builder.userPreferenceConsolidationOverride;
        this.type = builder.type;
    }

    /**
     * <p>
     * The semantic consolidation override configuration input.
     * </p>
     * 
     * @return The semantic consolidation override configuration input.
     */
    public final SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride() {
        return semanticConsolidationOverride;
    }

    /**
     * <p>
     * The summary consolidation override configuration input.
     * </p>
     * 
     * @return The summary consolidation override configuration input.
     */
    public final SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride() {
        return summaryConsolidationOverride;
    }

    /**
     * <p>
     * The user preference consolidation override configuration input.
     * </p>
     * 
     * @return The user preference consolidation override configuration input.
     */
    public final UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride() {
        return userPreferenceConsolidationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(summaryConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceConsolidationOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConsolidationConfigurationInput)) {
            return false;
        }
        CustomConsolidationConfigurationInput other = (CustomConsolidationConfigurationInput) obj;
        return Objects.equals(semanticConsolidationOverride(), other.semanticConsolidationOverride())
                && Objects.equals(summaryConsolidationOverride(), other.summaryConsolidationOverride())
                && Objects.equals(userPreferenceConsolidationOverride(), other.userPreferenceConsolidationOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConsolidationConfigurationInput")
                .add("SemanticConsolidationOverride", semanticConsolidationOverride())
                .add("SummaryConsolidationOverride", summaryConsolidationOverride())
                .add("UserPreferenceConsolidationOverride", userPreferenceConsolidationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticConsolidationOverride":
            return Optional.ofNullable(clazz.cast(semanticConsolidationOverride()));
        case "summaryConsolidationOverride":
            return Optional.ofNullable(clazz.cast(summaryConsolidationOverride()));
        case "userPreferenceConsolidationOverride":
            return Optional.ofNullable(clazz.cast(userPreferenceConsolidationOverride()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The semantic consolidation override configuration input.
     * </p>
     * 
     * @param semanticConsolidationOverride
     *        The semantic consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromSemanticConsolidationOverride(
            SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride) {
        return builder().semanticConsolidationOverride(semanticConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #semanticConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The semantic consolidation override configuration input.
     * </p>
     * 
     * @param semanticConsolidationOverride
     *        The semantic consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromSemanticConsolidationOverride(
            Consumer<SemanticOverrideConsolidationConfigurationInput.Builder> semanticConsolidationOverride) {
        SemanticOverrideConsolidationConfigurationInput.Builder builder = SemanticOverrideConsolidationConfigurationInput
                .builder();
        semanticConsolidationOverride.accept(builder);
        return fromSemanticConsolidationOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #summaryConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The summary consolidation override configuration input.
     * </p>
     * 
     * @param summaryConsolidationOverride
     *        The summary consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromSummaryConsolidationOverride(
            SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride) {
        return builder().summaryConsolidationOverride(summaryConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #summaryConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The summary consolidation override configuration input.
     * </p>
     * 
     * @param summaryConsolidationOverride
     *        The summary consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromSummaryConsolidationOverride(
            Consumer<SummaryOverrideConsolidationConfigurationInput.Builder> summaryConsolidationOverride) {
        SummaryOverrideConsolidationConfigurationInput.Builder builder = SummaryOverrideConsolidationConfigurationInput.builder();
        summaryConsolidationOverride.accept(builder);
        return fromSummaryConsolidationOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceConsolidationOverride()} initialized to the given
     * value.
     *
     * <p>
     * The user preference consolidation override configuration input.
     * </p>
     * 
     * @param userPreferenceConsolidationOverride
     *        The user preference consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromUserPreferenceConsolidationOverride(
            UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride) {
        return builder().userPreferenceConsolidationOverride(userPreferenceConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceConsolidationOverride()} initialized to the given
     * value.
     *
     * <p>
     * The user preference consolidation override configuration input.
     * </p>
     * 
     * @param userPreferenceConsolidationOverride
     *        The user preference consolidation override configuration input.
     */
    public static CustomConsolidationConfigurationInput fromUserPreferenceConsolidationOverride(
            Consumer<UserPreferenceOverrideConsolidationConfigurationInput.Builder> userPreferenceConsolidationOverride) {
        UserPreferenceOverrideConsolidationConfigurationInput.Builder builder = UserPreferenceOverrideConsolidationConfigurationInput
                .builder();
        userPreferenceConsolidationOverride.accept(builder);
        return fromUserPreferenceConsolidationOverride(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticConsolidationOverride", SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("summaryConsolidationOverride", SUMMARY_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("userPreferenceConsolidationOverride", USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConsolidationConfigurationInput, T> g) {
        return obj -> g.apply((CustomConsolidationConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConsolidationConfigurationInput> {
        /**
         * <p>
         * The semantic consolidation override configuration input.
         * </p>
         * 
         * @param semanticConsolidationOverride
         *        The semantic consolidation override configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticConsolidationOverride(SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride);

        /**
         * <p>
         * The semantic consolidation override configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SemanticOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SemanticOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticOverrideConsolidationConfigurationInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #semanticConsolidationOverride(SemanticOverrideConsolidationConfigurationInput)}.
         * 
         * @param semanticConsolidationOverride
         *        a consumer that will call methods on {@link SemanticOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticConsolidationOverride(SemanticOverrideConsolidationConfigurationInput)
         */
        default Builder semanticConsolidationOverride(
                Consumer<SemanticOverrideConsolidationConfigurationInput.Builder> semanticConsolidationOverride) {
            return semanticConsolidationOverride(SemanticOverrideConsolidationConfigurationInput.builder()
                    .applyMutation(semanticConsolidationOverride).build());
        }

        /**
         * <p>
         * The summary consolidation override configuration input.
         * </p>
         * 
         * @param summaryConsolidationOverride
         *        The summary consolidation override configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryConsolidationOverride(SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride);

        /**
         * <p>
         * The summary consolidation override configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SummaryOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SummaryOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryOverrideConsolidationConfigurationInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #summaryConsolidationOverride(SummaryOverrideConsolidationConfigurationInput)}.
         * 
         * @param summaryConsolidationOverride
         *        a consumer that will call methods on {@link SummaryOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryConsolidationOverride(SummaryOverrideConsolidationConfigurationInput)
         */
        default Builder summaryConsolidationOverride(
                Consumer<SummaryOverrideConsolidationConfigurationInput.Builder> summaryConsolidationOverride) {
            return summaryConsolidationOverride(SummaryOverrideConsolidationConfigurationInput.builder()
                    .applyMutation(summaryConsolidationOverride).build());
        }

        /**
         * <p>
         * The user preference consolidation override configuration input.
         * </p>
         * 
         * @param userPreferenceConsolidationOverride
         *        The user preference consolidation override configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceConsolidationOverride(
                UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride);

        /**
         * <p>
         * The user preference consolidation override configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one
         * manually via {@link UserPreferenceOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #userPreferenceConsolidationOverride(UserPreferenceOverrideConsolidationConfigurationInput)}.
         * 
         * @param userPreferenceConsolidationOverride
         *        a consumer that will call methods on
         *        {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceConsolidationOverride(UserPreferenceOverrideConsolidationConfigurationInput)
         */
        default Builder userPreferenceConsolidationOverride(
                Consumer<UserPreferenceOverrideConsolidationConfigurationInput.Builder> userPreferenceConsolidationOverride) {
            return userPreferenceConsolidationOverride(UserPreferenceOverrideConsolidationConfigurationInput.builder()
                    .applyMutation(userPreferenceConsolidationOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride;

        private SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride;

        private UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConsolidationConfigurationInput model) {
            semanticConsolidationOverride(model.semanticConsolidationOverride);
            summaryConsolidationOverride(model.summaryConsolidationOverride);
            userPreferenceConsolidationOverride(model.userPreferenceConsolidationOverride);
        }

        public final SemanticOverrideConsolidationConfigurationInput.Builder getSemanticConsolidationOverride() {
            return semanticConsolidationOverride != null ? semanticConsolidationOverride.toBuilder() : null;
        }

        public final void setSemanticConsolidationOverride(
                SemanticOverrideConsolidationConfigurationInput.BuilderImpl semanticConsolidationOverride) {
            Object oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride != null ? semanticConsolidationOverride.build()
                    : null;
            handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
        }

        @Override
        public final Builder semanticConsolidationOverride(
                SemanticOverrideConsolidationConfigurationInput semanticConsolidationOverride) {
            Object oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride;
            handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
            return this;
        }

        public final SummaryOverrideConsolidationConfigurationInput.Builder getSummaryConsolidationOverride() {
            return summaryConsolidationOverride != null ? summaryConsolidationOverride.toBuilder() : null;
        }

        public final void setSummaryConsolidationOverride(
                SummaryOverrideConsolidationConfigurationInput.BuilderImpl summaryConsolidationOverride) {
            Object oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride != null ? summaryConsolidationOverride.build()
                    : null;
            handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
        }

        @Override
        public final Builder summaryConsolidationOverride(
                SummaryOverrideConsolidationConfigurationInput summaryConsolidationOverride) {
            Object oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride;
            handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
            return this;
        }

        public final UserPreferenceOverrideConsolidationConfigurationInput.Builder getUserPreferenceConsolidationOverride() {
            return userPreferenceConsolidationOverride != null ? userPreferenceConsolidationOverride.toBuilder() : null;
        }

        public final void setUserPreferenceConsolidationOverride(
                UserPreferenceOverrideConsolidationConfigurationInput.BuilderImpl userPreferenceConsolidationOverride) {
            Object oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride != null ? userPreferenceConsolidationOverride
                    .build() : null;
            handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue,
                    this.userPreferenceConsolidationOverride);
        }

        @Override
        public final Builder userPreferenceConsolidationOverride(
                UserPreferenceOverrideConsolidationConfigurationInput userPreferenceConsolidationOverride) {
            Object oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride;
            handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue,
                    this.userPreferenceConsolidationOverride);
            return this;
        }

        @Override
        public CustomConsolidationConfigurationInput build() {
            return new CustomConsolidationConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomConsolidationConfigurationInput#type()
     */
    public enum Type {
        SEMANTIC_CONSOLIDATION_OVERRIDE,

        SUMMARY_CONSOLIDATION_OVERRIDE,

        USER_PREFERENCE_CONSOLIDATION_OVERRIDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
