/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains custom consolidation configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConsolidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConsolidationConfiguration.Builder, CustomConsolidationConfiguration> {
    private static final SdkField<SemanticConsolidationOverride> SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<SemanticConsolidationOverride> builder(MarshallingType.SDK_POJO)
            .memberName("semanticConsolidationOverride")
            .getter(getter(CustomConsolidationConfiguration::semanticConsolidationOverride))
            .setter(setter(Builder::semanticConsolidationOverride))
            .constructor(SemanticConsolidationOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticConsolidationOverride")
                    .build()).build();

    private static final SdkField<SummaryConsolidationOverride> SUMMARY_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<SummaryConsolidationOverride> builder(MarshallingType.SDK_POJO)
            .memberName("summaryConsolidationOverride")
            .getter(getter(CustomConsolidationConfiguration::summaryConsolidationOverride))
            .setter(setter(Builder::summaryConsolidationOverride))
            .constructor(SummaryConsolidationOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryConsolidationOverride")
                    .build()).build();

    private static final SdkField<UserPreferenceConsolidationOverride> USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD = SdkField
            .<UserPreferenceConsolidationOverride> builder(MarshallingType.SDK_POJO)
            .memberName("userPreferenceConsolidationOverride")
            .getter(getter(CustomConsolidationConfiguration::userPreferenceConsolidationOverride))
            .setter(setter(Builder::userPreferenceConsolidationOverride))
            .constructor(UserPreferenceConsolidationOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("userPreferenceConsolidationOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD, SUMMARY_CONSOLIDATION_OVERRIDE_FIELD,
            USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticConsolidationOverride semanticConsolidationOverride;

    private final SummaryConsolidationOverride summaryConsolidationOverride;

    private final UserPreferenceConsolidationOverride userPreferenceConsolidationOverride;

    private final Type type;

    private CustomConsolidationConfiguration(BuilderImpl builder) {
        this.semanticConsolidationOverride = builder.semanticConsolidationOverride;
        this.summaryConsolidationOverride = builder.summaryConsolidationOverride;
        this.userPreferenceConsolidationOverride = builder.userPreferenceConsolidationOverride;
        this.type = builder.type;
    }

    /**
     * <p>
     * The semantic consolidation override configuration.
     * </p>
     * 
     * @return The semantic consolidation override configuration.
     */
    public final SemanticConsolidationOverride semanticConsolidationOverride() {
        return semanticConsolidationOverride;
    }

    /**
     * <p>
     * The summary consolidation override configuration.
     * </p>
     * 
     * @return The summary consolidation override configuration.
     */
    public final SummaryConsolidationOverride summaryConsolidationOverride() {
        return summaryConsolidationOverride;
    }

    /**
     * <p>
     * The user preference consolidation override configuration.
     * </p>
     * 
     * @return The user preference consolidation override configuration.
     */
    public final UserPreferenceConsolidationOverride userPreferenceConsolidationOverride() {
        return userPreferenceConsolidationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(summaryConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceConsolidationOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConsolidationConfiguration)) {
            return false;
        }
        CustomConsolidationConfiguration other = (CustomConsolidationConfiguration) obj;
        return Objects.equals(semanticConsolidationOverride(), other.semanticConsolidationOverride())
                && Objects.equals(summaryConsolidationOverride(), other.summaryConsolidationOverride())
                && Objects.equals(userPreferenceConsolidationOverride(), other.userPreferenceConsolidationOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConsolidationConfiguration")
                .add("SemanticConsolidationOverride", semanticConsolidationOverride())
                .add("SummaryConsolidationOverride", summaryConsolidationOverride())
                .add("UserPreferenceConsolidationOverride", userPreferenceConsolidationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticConsolidationOverride":
            return Optional.ofNullable(clazz.cast(semanticConsolidationOverride()));
        case "summaryConsolidationOverride":
            return Optional.ofNullable(clazz.cast(summaryConsolidationOverride()));
        case "userPreferenceConsolidationOverride":
            return Optional.ofNullable(clazz.cast(userPreferenceConsolidationOverride()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The semantic consolidation override configuration.
     * </p>
     * 
     * @param semanticConsolidationOverride
     *        The semantic consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromSemanticConsolidationOverride(
            SemanticConsolidationOverride semanticConsolidationOverride) {
        return builder().semanticConsolidationOverride(semanticConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #semanticConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The semantic consolidation override configuration.
     * </p>
     * 
     * @param semanticConsolidationOverride
     *        The semantic consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromSemanticConsolidationOverride(
            Consumer<SemanticConsolidationOverride.Builder> semanticConsolidationOverride) {
        SemanticConsolidationOverride.Builder builder = SemanticConsolidationOverride.builder();
        semanticConsolidationOverride.accept(builder);
        return fromSemanticConsolidationOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #summaryConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The summary consolidation override configuration.
     * </p>
     * 
     * @param summaryConsolidationOverride
     *        The summary consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromSummaryConsolidationOverride(
            SummaryConsolidationOverride summaryConsolidationOverride) {
        return builder().summaryConsolidationOverride(summaryConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #summaryConsolidationOverride()} initialized to the given value.
     *
     * <p>
     * The summary consolidation override configuration.
     * </p>
     * 
     * @param summaryConsolidationOverride
     *        The summary consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromSummaryConsolidationOverride(
            Consumer<SummaryConsolidationOverride.Builder> summaryConsolidationOverride) {
        SummaryConsolidationOverride.Builder builder = SummaryConsolidationOverride.builder();
        summaryConsolidationOverride.accept(builder);
        return fromSummaryConsolidationOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceConsolidationOverride()} initialized to the given
     * value.
     *
     * <p>
     * The user preference consolidation override configuration.
     * </p>
     * 
     * @param userPreferenceConsolidationOverride
     *        The user preference consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromUserPreferenceConsolidationOverride(
            UserPreferenceConsolidationOverride userPreferenceConsolidationOverride) {
        return builder().userPreferenceConsolidationOverride(userPreferenceConsolidationOverride).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceConsolidationOverride()} initialized to the given
     * value.
     *
     * <p>
     * The user preference consolidation override configuration.
     * </p>
     * 
     * @param userPreferenceConsolidationOverride
     *        The user preference consolidation override configuration.
     */
    public static CustomConsolidationConfiguration fromUserPreferenceConsolidationOverride(
            Consumer<UserPreferenceConsolidationOverride.Builder> userPreferenceConsolidationOverride) {
        UserPreferenceConsolidationOverride.Builder builder = UserPreferenceConsolidationOverride.builder();
        userPreferenceConsolidationOverride.accept(builder);
        return fromUserPreferenceConsolidationOverride(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticConsolidationOverride", SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("summaryConsolidationOverride", SUMMARY_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("userPreferenceConsolidationOverride", USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConsolidationConfiguration, T> g) {
        return obj -> g.apply((CustomConsolidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConsolidationConfiguration> {
        /**
         * <p>
         * The semantic consolidation override configuration.
         * </p>
         * 
         * @param semanticConsolidationOverride
         *        The semantic consolidation override configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticConsolidationOverride(SemanticConsolidationOverride semanticConsolidationOverride);

        /**
         * <p>
         * The semantic consolidation override configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticConsolidationOverride.Builder}
         * avoiding the need to create one manually via {@link SemanticConsolidationOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticConsolidationOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #semanticConsolidationOverride(SemanticConsolidationOverride)}.
         * 
         * @param semanticConsolidationOverride
         *        a consumer that will call methods on {@link SemanticConsolidationOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticConsolidationOverride(SemanticConsolidationOverride)
         */
        default Builder semanticConsolidationOverride(
                Consumer<SemanticConsolidationOverride.Builder> semanticConsolidationOverride) {
            return semanticConsolidationOverride(SemanticConsolidationOverride.builder()
                    .applyMutation(semanticConsolidationOverride).build());
        }

        /**
         * <p>
         * The summary consolidation override configuration.
         * </p>
         * 
         * @param summaryConsolidationOverride
         *        The summary consolidation override configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryConsolidationOverride(SummaryConsolidationOverride summaryConsolidationOverride);

        /**
         * <p>
         * The summary consolidation override configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummaryConsolidationOverride.Builder}
         * avoiding the need to create one manually via {@link SummaryConsolidationOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryConsolidationOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #summaryConsolidationOverride(SummaryConsolidationOverride)}.
         * 
         * @param summaryConsolidationOverride
         *        a consumer that will call methods on {@link SummaryConsolidationOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryConsolidationOverride(SummaryConsolidationOverride)
         */
        default Builder summaryConsolidationOverride(Consumer<SummaryConsolidationOverride.Builder> summaryConsolidationOverride) {
            return summaryConsolidationOverride(SummaryConsolidationOverride.builder()
                    .applyMutation(summaryConsolidationOverride).build());
        }

        /**
         * <p>
         * The user preference consolidation override configuration.
         * </p>
         * 
         * @param userPreferenceConsolidationOverride
         *        The user preference consolidation override configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride userPreferenceConsolidationOverride);

        /**
         * <p>
         * The user preference consolidation override configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceConsolidationOverride.Builder} avoiding the need to create one manually via
         * {@link UserPreferenceConsolidationOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPreferenceConsolidationOverride.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride)}.
         * 
         * @param userPreferenceConsolidationOverride
         *        a consumer that will call methods on {@link UserPreferenceConsolidationOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride)
         */
        default Builder userPreferenceConsolidationOverride(
                Consumer<UserPreferenceConsolidationOverride.Builder> userPreferenceConsolidationOverride) {
            return userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride.builder()
                    .applyMutation(userPreferenceConsolidationOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticConsolidationOverride semanticConsolidationOverride;

        private SummaryConsolidationOverride summaryConsolidationOverride;

        private UserPreferenceConsolidationOverride userPreferenceConsolidationOverride;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConsolidationConfiguration model) {
            semanticConsolidationOverride(model.semanticConsolidationOverride);
            summaryConsolidationOverride(model.summaryConsolidationOverride);
            userPreferenceConsolidationOverride(model.userPreferenceConsolidationOverride);
        }

        public final SemanticConsolidationOverride.Builder getSemanticConsolidationOverride() {
            return semanticConsolidationOverride != null ? semanticConsolidationOverride.toBuilder() : null;
        }

        public final void setSemanticConsolidationOverride(SemanticConsolidationOverride.BuilderImpl semanticConsolidationOverride) {
            Object oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride != null ? semanticConsolidationOverride.build()
                    : null;
            handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
        }

        @Override
        public final Builder semanticConsolidationOverride(SemanticConsolidationOverride semanticConsolidationOverride) {
            Object oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride;
            handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
            return this;
        }

        public final SummaryConsolidationOverride.Builder getSummaryConsolidationOverride() {
            return summaryConsolidationOverride != null ? summaryConsolidationOverride.toBuilder() : null;
        }

        public final void setSummaryConsolidationOverride(SummaryConsolidationOverride.BuilderImpl summaryConsolidationOverride) {
            Object oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride != null ? summaryConsolidationOverride.build()
                    : null;
            handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
        }

        @Override
        public final Builder summaryConsolidationOverride(SummaryConsolidationOverride summaryConsolidationOverride) {
            Object oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride;
            handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
            return this;
        }

        public final UserPreferenceConsolidationOverride.Builder getUserPreferenceConsolidationOverride() {
            return userPreferenceConsolidationOverride != null ? userPreferenceConsolidationOverride.toBuilder() : null;
        }

        public final void setUserPreferenceConsolidationOverride(
                UserPreferenceConsolidationOverride.BuilderImpl userPreferenceConsolidationOverride) {
            Object oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride != null ? userPreferenceConsolidationOverride
                    .build() : null;
            handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue,
                    this.userPreferenceConsolidationOverride);
        }

        @Override
        public final Builder userPreferenceConsolidationOverride(
                UserPreferenceConsolidationOverride userPreferenceConsolidationOverride) {
            Object oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride;
            handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue,
                    this.userPreferenceConsolidationOverride);
            return this;
        }

        @Override
        public CustomConsolidationConfiguration build() {
            return new CustomConsolidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomConsolidationConfiguration#type()
     */
    public enum Type {
        SEMANTIC_CONSOLIDATION_OVERRIDE,

        SUMMARY_CONSOLIDATION_OVERRIDE,

        USER_PREFERENCE_CONSOLIDATION_OVERRIDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
