/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for custom configuration of a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomConfigurationInput.Builder, CustomConfigurationInput> {
    private static final SdkField<SemanticOverrideConfigurationInput> SEMANTIC_OVERRIDE_FIELD = SdkField
            .<SemanticOverrideConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("semanticOverride")
            .getter(getter(CustomConfigurationInput::semanticOverride)).setter(setter(Builder::semanticOverride))
            .constructor(SemanticOverrideConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticOverride").build()).build();

    private static final SdkField<SummaryOverrideConfigurationInput> SUMMARY_OVERRIDE_FIELD = SdkField
            .<SummaryOverrideConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("summaryOverride")
            .getter(getter(CustomConfigurationInput::summaryOverride)).setter(setter(Builder::summaryOverride))
            .constructor(SummaryOverrideConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryOverride").build()).build();

    private static final SdkField<UserPreferenceOverrideConfigurationInput> USER_PREFERENCE_OVERRIDE_FIELD = SdkField
            .<UserPreferenceOverrideConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("userPreferenceOverride")
            .getter(getter(CustomConfigurationInput::userPreferenceOverride)).setter(setter(Builder::userPreferenceOverride))
            .constructor(UserPreferenceOverrideConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_OVERRIDE_FIELD,
            SUMMARY_OVERRIDE_FIELD, USER_PREFERENCE_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticOverrideConfigurationInput semanticOverride;

    private final SummaryOverrideConfigurationInput summaryOverride;

    private final UserPreferenceOverrideConfigurationInput userPreferenceOverride;

    private final Type type;

    private CustomConfigurationInput(BuilderImpl builder) {
        this.semanticOverride = builder.semanticOverride;
        this.summaryOverride = builder.summaryOverride;
        this.userPreferenceOverride = builder.userPreferenceOverride;
        this.type = builder.type;
    }

    /**
     * <p>
     * The semantic override configuration for a custom memory strategy.
     * </p>
     * 
     * @return The semantic override configuration for a custom memory strategy.
     */
    public final SemanticOverrideConfigurationInput semanticOverride() {
        return semanticOverride;
    }

    /**
     * <p>
     * The summary override configuration for a custom memory strategy.
     * </p>
     * 
     * @return The summary override configuration for a custom memory strategy.
     */
    public final SummaryOverrideConfigurationInput summaryOverride() {
        return summaryOverride;
    }

    /**
     * <p>
     * The user preference override configuration for a custom memory strategy.
     * </p>
     * 
     * @return The user preference override configuration for a custom memory strategy.
     */
    public final UserPreferenceOverrideConfigurationInput userPreferenceOverride() {
        return userPreferenceOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticOverride());
        hashCode = 31 * hashCode + Objects.hashCode(summaryOverride());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConfigurationInput)) {
            return false;
        }
        CustomConfigurationInput other = (CustomConfigurationInput) obj;
        return Objects.equals(semanticOverride(), other.semanticOverride())
                && Objects.equals(summaryOverride(), other.summaryOverride())
                && Objects.equals(userPreferenceOverride(), other.userPreferenceOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomConfigurationInput").add("SemanticOverride", semanticOverride())
                .add("SummaryOverride", summaryOverride()).add("UserPreferenceOverride", userPreferenceOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticOverride":
            return Optional.ofNullable(clazz.cast(semanticOverride()));
        case "summaryOverride":
            return Optional.ofNullable(clazz.cast(summaryOverride()));
        case "userPreferenceOverride":
            return Optional.ofNullable(clazz.cast(userPreferenceOverride()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticOverride()} initialized to the given value.
     *
     * <p>
     * The semantic override configuration for a custom memory strategy.
     * </p>
     * 
     * @param semanticOverride
     *        The semantic override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromSemanticOverride(SemanticOverrideConfigurationInput semanticOverride) {
        return builder().semanticOverride(semanticOverride).build();
    }

    /**
     * Create an instance of this class with {@link #semanticOverride()} initialized to the given value.
     *
     * <p>
     * The semantic override configuration for a custom memory strategy.
     * </p>
     * 
     * @param semanticOverride
     *        The semantic override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromSemanticOverride(
            Consumer<SemanticOverrideConfigurationInput.Builder> semanticOverride) {
        SemanticOverrideConfigurationInput.Builder builder = SemanticOverrideConfigurationInput.builder();
        semanticOverride.accept(builder);
        return fromSemanticOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #summaryOverride()} initialized to the given value.
     *
     * <p>
     * The summary override configuration for a custom memory strategy.
     * </p>
     * 
     * @param summaryOverride
     *        The summary override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromSummaryOverride(SummaryOverrideConfigurationInput summaryOverride) {
        return builder().summaryOverride(summaryOverride).build();
    }

    /**
     * Create an instance of this class with {@link #summaryOverride()} initialized to the given value.
     *
     * <p>
     * The summary override configuration for a custom memory strategy.
     * </p>
     * 
     * @param summaryOverride
     *        The summary override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromSummaryOverride(Consumer<SummaryOverrideConfigurationInput.Builder> summaryOverride) {
        SummaryOverrideConfigurationInput.Builder builder = SummaryOverrideConfigurationInput.builder();
        summaryOverride.accept(builder);
        return fromSummaryOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceOverride()} initialized to the given value.
     *
     * <p>
     * The user preference override configuration for a custom memory strategy.
     * </p>
     * 
     * @param userPreferenceOverride
     *        The user preference override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromUserPreferenceOverride(
            UserPreferenceOverrideConfigurationInput userPreferenceOverride) {
        return builder().userPreferenceOverride(userPreferenceOverride).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceOverride()} initialized to the given value.
     *
     * <p>
     * The user preference override configuration for a custom memory strategy.
     * </p>
     * 
     * @param userPreferenceOverride
     *        The user preference override configuration for a custom memory strategy.
     */
    public static CustomConfigurationInput fromUserPreferenceOverride(
            Consumer<UserPreferenceOverrideConfigurationInput.Builder> userPreferenceOverride) {
        UserPreferenceOverrideConfigurationInput.Builder builder = UserPreferenceOverrideConfigurationInput.builder();
        userPreferenceOverride.accept(builder);
        return fromUserPreferenceOverride(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticOverride", SEMANTIC_OVERRIDE_FIELD);
        map.put("summaryOverride", SUMMARY_OVERRIDE_FIELD);
        map.put("userPreferenceOverride", USER_PREFERENCE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConfigurationInput, T> g) {
        return obj -> g.apply((CustomConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomConfigurationInput> {
        /**
         * <p>
         * The semantic override configuration for a custom memory strategy.
         * </p>
         * 
         * @param semanticOverride
         *        The semantic override configuration for a custom memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticOverride(SemanticOverrideConfigurationInput semanticOverride);

        /**
         * <p>
         * The semantic override configuration for a custom memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SemanticOverrideConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SemanticOverrideConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticOverrideConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #semanticOverride(SemanticOverrideConfigurationInput)}.
         * 
         * @param semanticOverride
         *        a consumer that will call methods on {@link SemanticOverrideConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticOverride(SemanticOverrideConfigurationInput)
         */
        default Builder semanticOverride(Consumer<SemanticOverrideConfigurationInput.Builder> semanticOverride) {
            return semanticOverride(SemanticOverrideConfigurationInput.builder().applyMutation(semanticOverride).build());
        }

        /**
         * <p>
         * The summary override configuration for a custom memory strategy.
         * </p>
         * 
         * @param summaryOverride
         *        The summary override configuration for a custom memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryOverride(SummaryOverrideConfigurationInput summaryOverride);

        /**
         * <p>
         * The summary override configuration for a custom memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SummaryOverrideConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SummaryOverrideConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryOverrideConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #summaryOverride(SummaryOverrideConfigurationInput)}.
         * 
         * @param summaryOverride
         *        a consumer that will call methods on {@link SummaryOverrideConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryOverride(SummaryOverrideConfigurationInput)
         */
        default Builder summaryOverride(Consumer<SummaryOverrideConfigurationInput.Builder> summaryOverride) {
            return summaryOverride(SummaryOverrideConfigurationInput.builder().applyMutation(summaryOverride).build());
        }

        /**
         * <p>
         * The user preference override configuration for a custom memory strategy.
         * </p>
         * 
         * @param userPreferenceOverride
         *        The user preference override configuration for a custom memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceOverride(UserPreferenceOverrideConfigurationInput userPreferenceOverride);

        /**
         * <p>
         * The user preference override configuration for a custom memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceOverrideConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link UserPreferenceOverrideConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPreferenceOverrideConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #userPreferenceOverride(UserPreferenceOverrideConfigurationInput)}.
         * 
         * @param userPreferenceOverride
         *        a consumer that will call methods on {@link UserPreferenceOverrideConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceOverride(UserPreferenceOverrideConfigurationInput)
         */
        default Builder userPreferenceOverride(Consumer<UserPreferenceOverrideConfigurationInput.Builder> userPreferenceOverride) {
            return userPreferenceOverride(UserPreferenceOverrideConfigurationInput.builder()
                    .applyMutation(userPreferenceOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticOverrideConfigurationInput semanticOverride;

        private SummaryOverrideConfigurationInput summaryOverride;

        private UserPreferenceOverrideConfigurationInput userPreferenceOverride;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConfigurationInput model) {
            semanticOverride(model.semanticOverride);
            summaryOverride(model.summaryOverride);
            userPreferenceOverride(model.userPreferenceOverride);
        }

        public final SemanticOverrideConfigurationInput.Builder getSemanticOverride() {
            return semanticOverride != null ? semanticOverride.toBuilder() : null;
        }

        public final void setSemanticOverride(SemanticOverrideConfigurationInput.BuilderImpl semanticOverride) {
            Object oldValue = this.semanticOverride;
            this.semanticOverride = semanticOverride != null ? semanticOverride.build() : null;
            handleUnionValueChange(Type.SEMANTIC_OVERRIDE, oldValue, this.semanticOverride);
        }

        @Override
        public final Builder semanticOverride(SemanticOverrideConfigurationInput semanticOverride) {
            Object oldValue = this.semanticOverride;
            this.semanticOverride = semanticOverride;
            handleUnionValueChange(Type.SEMANTIC_OVERRIDE, oldValue, this.semanticOverride);
            return this;
        }

        public final SummaryOverrideConfigurationInput.Builder getSummaryOverride() {
            return summaryOverride != null ? summaryOverride.toBuilder() : null;
        }

        public final void setSummaryOverride(SummaryOverrideConfigurationInput.BuilderImpl summaryOverride) {
            Object oldValue = this.summaryOverride;
            this.summaryOverride = summaryOverride != null ? summaryOverride.build() : null;
            handleUnionValueChange(Type.SUMMARY_OVERRIDE, oldValue, this.summaryOverride);
        }

        @Override
        public final Builder summaryOverride(SummaryOverrideConfigurationInput summaryOverride) {
            Object oldValue = this.summaryOverride;
            this.summaryOverride = summaryOverride;
            handleUnionValueChange(Type.SUMMARY_OVERRIDE, oldValue, this.summaryOverride);
            return this;
        }

        public final UserPreferenceOverrideConfigurationInput.Builder getUserPreferenceOverride() {
            return userPreferenceOverride != null ? userPreferenceOverride.toBuilder() : null;
        }

        public final void setUserPreferenceOverride(UserPreferenceOverrideConfigurationInput.BuilderImpl userPreferenceOverride) {
            Object oldValue = this.userPreferenceOverride;
            this.userPreferenceOverride = userPreferenceOverride != null ? userPreferenceOverride.build() : null;
            handleUnionValueChange(Type.USER_PREFERENCE_OVERRIDE, oldValue, this.userPreferenceOverride);
        }

        @Override
        public final Builder userPreferenceOverride(UserPreferenceOverrideConfigurationInput userPreferenceOverride) {
            Object oldValue = this.userPreferenceOverride;
            this.userPreferenceOverride = userPreferenceOverride;
            handleUnionValueChange(Type.USER_PREFERENCE_OVERRIDE, oldValue, this.userPreferenceOverride);
            return this;
        }

        @Override
        public CustomConfigurationInput build() {
            return new CustomConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomConfigurationInput#type()
     */
    public enum Type {
        SEMANTIC_OVERRIDE,

        SUMMARY_OVERRIDE,

        USER_PREFERENCE_OVERRIDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
