/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a credential provider. This structure defines how the gateway authenticates with the target
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CredentialProviderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CredentialProviderConfiguration.Builder, CredentialProviderConfiguration> {
    private static final SdkField<String> CREDENTIAL_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialProviderType").getter(getter(CredentialProviderConfiguration::credentialProviderTypeAsString))
            .setter(setter(Builder::credentialProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderType").build())
            .build();

    private static final SdkField<CredentialProvider> CREDENTIAL_PROVIDER_FIELD = SdkField
            .<CredentialProvider> builder(MarshallingType.SDK_POJO).memberName("credentialProvider")
            .getter(getter(CredentialProviderConfiguration::credentialProvider)).setter(setter(Builder::credentialProvider))
            .constructor(CredentialProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CREDENTIAL_PROVIDER_TYPE_FIELD, CREDENTIAL_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String credentialProviderType;

    private final CredentialProvider credentialProvider;

    private CredentialProviderConfiguration(BuilderImpl builder) {
        this.credentialProviderType = builder.credentialProviderType;
        this.credentialProvider = builder.credentialProvider;
    }

    /**
     * <p>
     * The type of credential provider. This field specifies which authentication method the gateway uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialProviderType} will return {@link CredentialProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #credentialProviderTypeAsString}.
     * </p>
     * 
     * @return The type of credential provider. This field specifies which authentication method the gateway uses.
     * @see CredentialProviderType
     */
    public final CredentialProviderType credentialProviderType() {
        return CredentialProviderType.fromValue(credentialProviderType);
    }

    /**
     * <p>
     * The type of credential provider. This field specifies which authentication method the gateway uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialProviderType} will return {@link CredentialProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #credentialProviderTypeAsString}.
     * </p>
     * 
     * @return The type of credential provider. This field specifies which authentication method the gateway uses.
     * @see CredentialProviderType
     */
    public final String credentialProviderTypeAsString() {
        return credentialProviderType;
    }

    /**
     * <p>
     * The credential provider. This field contains the specific configuration for the credential provider type.
     * </p>
     * 
     * @return The credential provider. This field contains the specific configuration for the credential provider type.
     */
    public final CredentialProvider credentialProvider() {
        return credentialProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialProviderConfiguration)) {
            return false;
        }
        CredentialProviderConfiguration other = (CredentialProviderConfiguration) obj;
        return Objects.equals(credentialProviderTypeAsString(), other.credentialProviderTypeAsString())
                && Objects.equals(credentialProvider(), other.credentialProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CredentialProviderConfiguration")
                .add("CredentialProviderType", credentialProviderTypeAsString()).add("CredentialProvider", credentialProvider())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentialProviderType":
            return Optional.ofNullable(clazz.cast(credentialProviderTypeAsString()));
        case "credentialProvider":
            return Optional.ofNullable(clazz.cast(credentialProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("credentialProviderType", CREDENTIAL_PROVIDER_TYPE_FIELD);
        map.put("credentialProvider", CREDENTIAL_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialProviderConfiguration, T> g) {
        return obj -> g.apply((CredentialProviderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CredentialProviderConfiguration> {
        /**
         * <p>
         * The type of credential provider. This field specifies which authentication method the gateway uses.
         * </p>
         * 
         * @param credentialProviderType
         *        The type of credential provider. This field specifies which authentication method the gateway uses.
         * @see CredentialProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialProviderType
         */
        Builder credentialProviderType(String credentialProviderType);

        /**
         * <p>
         * The type of credential provider. This field specifies which authentication method the gateway uses.
         * </p>
         * 
         * @param credentialProviderType
         *        The type of credential provider. This field specifies which authentication method the gateway uses.
         * @see CredentialProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialProviderType
         */
        Builder credentialProviderType(CredentialProviderType credentialProviderType);

        /**
         * <p>
         * The credential provider. This field contains the specific configuration for the credential provider type.
         * </p>
         * 
         * @param credentialProvider
         *        The credential provider. This field contains the specific configuration for the credential provider
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProvider(CredentialProvider credentialProvider);

        /**
         * <p>
         * The credential provider. This field contains the specific configuration for the credential provider type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CredentialProvider.Builder} avoiding the
         * need to create one manually via {@link CredentialProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CredentialProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #credentialProvider(CredentialProvider)}.
         * 
         * @param credentialProvider
         *        a consumer that will call methods on {@link CredentialProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialProvider(CredentialProvider)
         */
        default Builder credentialProvider(Consumer<CredentialProvider.Builder> credentialProvider) {
            return credentialProvider(CredentialProvider.builder().applyMutation(credentialProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String credentialProviderType;

        private CredentialProvider credentialProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialProviderConfiguration model) {
            credentialProviderType(model.credentialProviderType);
            credentialProvider(model.credentialProvider);
        }

        public final String getCredentialProviderType() {
            return credentialProviderType;
        }

        public final void setCredentialProviderType(String credentialProviderType) {
            this.credentialProviderType = credentialProviderType;
        }

        @Override
        public final Builder credentialProviderType(String credentialProviderType) {
            this.credentialProviderType = credentialProviderType;
            return this;
        }

        @Override
        public final Builder credentialProviderType(CredentialProviderType credentialProviderType) {
            this.credentialProviderType(credentialProviderType == null ? null : credentialProviderType.toString());
            return this;
        }

        public final CredentialProvider.Builder getCredentialProvider() {
            return credentialProvider != null ? credentialProvider.toBuilder() : null;
        }

        public final void setCredentialProvider(CredentialProvider.BuilderImpl credentialProvider) {
            this.credentialProvider = credentialProvider != null ? credentialProvider.build() : null;
        }

        @Override
        public final Builder credentialProvider(CredentialProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Override
        public CredentialProviderConfiguration build() {
            return new CredentialProviderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
