/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMemoryResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<CreateMemoryResponse.Builder, CreateMemoryResponse> {
    private static final SdkField<Memory> MEMORY_FIELD = SdkField.<Memory> builder(MarshallingType.SDK_POJO).memberName("memory")
            .getter(getter(CreateMemoryResponse::memory)).setter(setter(Builder::memory)).constructor(Memory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Memory memory;

    private CreateMemoryResponse(BuilderImpl builder) {
        super(builder);
        this.memory = builder.memory;
    }

    /**
     * <p>
     * The details of the created memory, including its ID, ARN, name, description, and configuration settings.
     * </p>
     * 
     * @return The details of the created memory, including its ID, ARN, name, description, and configuration settings.
     */
    public final Memory memory() {
        return memory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemoryResponse)) {
            return false;
        }
        CreateMemoryResponse other = (CreateMemoryResponse) obj;
        return Objects.equals(memory(), other.memory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMemoryResponse").add("Memory", memory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memory", MEMORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMemoryResponse, T> g) {
        return obj -> g.apply((CreateMemoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMemoryResponse> {
        /**
         * <p>
         * The details of the created memory, including its ID, ARN, name, description, and configuration settings.
         * </p>
         * 
         * @param memory
         *        The details of the created memory, including its ID, ARN, name, description, and configuration
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Memory memory);

        /**
         * <p>
         * The details of the created memory, including its ID, ARN, name, description, and configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link Memory.Builder} avoiding the need to
         * create one manually via {@link Memory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Memory.Builder#build()} is called immediately and its result is
         * passed to {@link #memory(Memory)}.
         * 
         * @param memory
         *        a consumer that will call methods on {@link Memory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memory(Memory)
         */
        default Builder memory(Consumer<Memory.Builder> memory) {
            return memory(Memory.builder().applyMutation(memory).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private Memory memory;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemoryResponse model) {
            super(model);
            memory(model.memory);
        }

        public final Memory.Builder getMemory() {
            return memory != null ? memory.toBuilder() : null;
        }

        public final void setMemory(Memory.BuilderImpl memory) {
            this.memory = memory != null ? memory.build() : null;
        }

        @Override
        public final Builder memory(Memory memory) {
            this.memory = memory;
            return this;
        }

        @Override
        public CreateMemoryResponse build() {
            return new CreateMemoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
