/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMemoryRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<CreateMemoryRequest.Builder, CreateMemoryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateMemoryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMemoryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateMemoryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKeyArn").getter(getter(CreateMemoryRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()).build();

    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryExecutionRoleArn").getter(getter(CreateMemoryRequest::memoryExecutionRoleArn))
            .setter(setter(Builder::memoryExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build())
            .build();

    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("eventExpiryDuration").getter(getter(CreateMemoryRequest::eventExpiryDuration))
            .setter(setter(Builder::eventExpiryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build())
            .build();

    private static final SdkField<List<MemoryStrategyInput>> MEMORY_STRATEGIES_FIELD = SdkField
            .<List<MemoryStrategyInput>> builder(MarshallingType.LIST)
            .memberName("memoryStrategies")
            .getter(getter(CreateMemoryRequest::memoryStrategies))
            .setter(setter(Builder::memoryStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemoryStrategyInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemoryStrategyInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ENCRYPTION_KEY_ARN_FIELD, MEMORY_EXECUTION_ROLE_ARN_FIELD,
            EVENT_EXPIRY_DURATION_FIELD, MEMORY_STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String name;

    private final String description;

    private final String encryptionKeyArn;

    private final String memoryExecutionRoleArn;

    private final Integer eventExpiryDuration;

    private final List<MemoryStrategyInput> memoryStrategies;

    private CreateMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.memoryStrategies = builder.memoryStrategies;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request but does not return an error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the memory. The name must be unique within your account.
     * </p>
     * 
     * @return The name of the memory. The name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the memory.
     * </p>
     * 
     * @return The description of the memory.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the memory data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key used to encrypt the memory data.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the memory to access Amazon Web
     * Services services.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that provides permissions for the memory to access Amazon
     *         Web Services services.
     */
    public final String memoryExecutionRoleArn() {
        return memoryExecutionRoleArn;
    }

    /**
     * <p>
     * The duration after which memory events expire. Specified as an ISO 8601 duration.
     * </p>
     * 
     * @return The duration after which memory events expire. Specified as an ISO 8601 duration.
     */
    public final Integer eventExpiryDuration() {
        return eventExpiryDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemoryStrategies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemoryStrategies() {
        return memoryStrategies != null && !(memoryStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The memory strategies to use for this memory. Strategies define how information is extracted, processed, and
     * consolidated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemoryStrategies} method.
     * </p>
     * 
     * @return The memory strategies to use for this memory. Strategies define how information is extracted, processed,
     *         and consolidated.
     */
    public final List<MemoryStrategyInput> memoryStrategies() {
        return memoryStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemoryStrategies() ? memoryStrategies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemoryRequest)) {
            return false;
        }
        CreateMemoryRequest other = (CreateMemoryRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(memoryExecutionRoleArn(), other.memoryExecutionRoleArn())
                && Objects.equals(eventExpiryDuration(), other.eventExpiryDuration())
                && hasMemoryStrategies() == other.hasMemoryStrategies()
                && Objects.equals(memoryStrategies(), other.memoryStrategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMemoryRequest").add("ClientToken", clientToken()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncryptionKeyArn", encryptionKeyArn()).add("MemoryExecutionRoleArn", memoryExecutionRoleArn())
                .add("EventExpiryDuration", eventExpiryDuration())
                .add("MemoryStrategies", hasMemoryStrategies() ? memoryStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "encryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "memoryExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(memoryExecutionRoleArn()));
        case "eventExpiryDuration":
            return Optional.ofNullable(clazz.cast(eventExpiryDuration()));
        case "memoryStrategies":
            return Optional.ofNullable(clazz.cast(memoryStrategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("memoryStrategies", MEMORY_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMemoryRequest, T> g) {
        return obj -> g.apply((CreateMemoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMemoryRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request but does not return an error.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the memory. The name must be unique within your account.
         * </p>
         * 
         * @param name
         *        The name of the memory. The name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the memory.
         * </p>
         * 
         * @param description
         *        The description of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the memory data.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key used to encrypt the memory data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the memory to access Amazon Web
         * Services services.
         * </p>
         * 
         * @param memoryExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that provides permissions for the memory to access
         *        Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryExecutionRoleArn(String memoryExecutionRoleArn);

        /**
         * <p>
         * The duration after which memory events expire. Specified as an ISO 8601 duration.
         * </p>
         * 
         * @param eventExpiryDuration
         *        The duration after which memory events expire. Specified as an ISO 8601 duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventExpiryDuration(Integer eventExpiryDuration);

        /**
         * <p>
         * The memory strategies to use for this memory. Strategies define how information is extracted, processed, and
         * consolidated.
         * </p>
         * 
         * @param memoryStrategies
         *        The memory strategies to use for this memory. Strategies define how information is extracted,
         *        processed, and consolidated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategies(Collection<MemoryStrategyInput> memoryStrategies);

        /**
         * <p>
         * The memory strategies to use for this memory. Strategies define how information is extracted, processed, and
         * consolidated.
         * </p>
         * 
         * @param memoryStrategies
         *        The memory strategies to use for this memory. Strategies define how information is extracted,
         *        processed, and consolidated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategies(MemoryStrategyInput... memoryStrategies);

        /**
         * <p>
         * The memory strategies to use for this memory. Strategies define how information is extracted, processed, and
         * consolidated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder#build()} is
         * called immediately and its result is passed to {@link #memoryStrategies(List<MemoryStrategyInput>)}.
         * 
         * @param memoryStrategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryStrategies(java.util.Collection<MemoryStrategyInput>)
         */
        Builder memoryStrategies(Consumer<MemoryStrategyInput.Builder>... memoryStrategies);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private String description;

        private String encryptionKeyArn;

        private String memoryExecutionRoleArn;

        private Integer eventExpiryDuration;

        private List<MemoryStrategyInput> memoryStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemoryRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            description(model.description);
            encryptionKeyArn(model.encryptionKeyArn);
            memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            eventExpiryDuration(model.eventExpiryDuration);
            memoryStrategies(model.memoryStrategies);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final List<MemoryStrategyInput.Builder> getMemoryStrategies() {
            List<MemoryStrategyInput.Builder> result = MemoryStrategyInputListCopier.copyToBuilder(this.memoryStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemoryStrategies(Collection<MemoryStrategyInput.BuilderImpl> memoryStrategies) {
            this.memoryStrategies = MemoryStrategyInputListCopier.copyFromBuilder(memoryStrategies);
        }

        @Override
        public final Builder memoryStrategies(Collection<MemoryStrategyInput> memoryStrategies) {
            this.memoryStrategies = MemoryStrategyInputListCopier.copy(memoryStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryStrategies(MemoryStrategyInput... memoryStrategies) {
            memoryStrategies(Arrays.asList(memoryStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryStrategies(Consumer<MemoryStrategyInput.Builder>... memoryStrategies) {
            memoryStrategies(Stream.of(memoryStrategies).map(c -> MemoryStrategyInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMemoryRequest build() {
            return new CreateMemoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
