/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentRuntimeEndpointRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<CreateAgentRuntimeEndpointRequest.Builder, CreateAgentRuntimeEndpointRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(CreateAgentRuntimeEndpointRequest::agentRuntimeId))
            .setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAgentRuntimeEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeVersion").getter(getter(CreateAgentRuntimeEndpointRequest::agentRuntimeVersion))
            .setter(setter(Builder::agentRuntimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAgentRuntimeEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAgentRuntimeEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD,
            NAME_FIELD, AGENT_RUNTIME_VERSION_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeId;

    private final String name;

    private final String agentRuntimeVersion;

    private final String description;

    private final String clientToken;

    private CreateAgentRuntimeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.name = builder.name;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime to create an endpoint for.
     * </p>
     * 
     * @return The unique identifier of the agent runtime to create an endpoint for.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The name of the agent runtime endpoint.
     * </p>
     * 
     * @return The name of the agent runtime endpoint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the agent runtime to use for the endpoint.
     * </p>
     * 
     * @return The version of the agent runtime to use for the endpoint.
     */
    public final String agentRuntimeVersion() {
        return agentRuntimeVersion;
    }

    /**
     * <p>
     * The description of the agent runtime endpoint.
     * </p>
     * 
     * @return The description of the agent runtime endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeEndpointRequest)) {
            return false;
        }
        CreateAgentRuntimeEndpointRequest other = (CreateAgentRuntimeEndpointRequest) obj;
        return Objects.equals(agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(name(), other.name())
                && Objects.equals(agentRuntimeVersion(), other.agentRuntimeVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentRuntimeEndpointRequest").add("AgentRuntimeId", agentRuntimeId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AgentRuntimeVersion", agentRuntimeVersion()).add("Description", description())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "agentRuntimeVersion":
            return Optional.ofNullable(clazz.cast(agentRuntimeVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeEndpointRequest, T> g) {
        return obj -> g.apply((CreateAgentRuntimeEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAgentRuntimeEndpointRequest> {
        /**
         * <p>
         * The unique identifier of the agent runtime to create an endpoint for.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the agent runtime to create an endpoint for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The name of the agent runtime endpoint.
         * </p>
         * 
         * @param name
         *        The name of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the agent runtime to use for the endpoint.
         * </p>
         * 
         * @param agentRuntimeVersion
         *        The version of the agent runtime to use for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeVersion(String agentRuntimeVersion);

        /**
         * <p>
         * The description of the agent runtime endpoint.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String agentRuntimeId;

        private String name;

        private String agentRuntimeVersion;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeEndpointRequest model) {
            super(model);
            agentRuntimeId(model.agentRuntimeId);
            name(model.name);
            agentRuntimeVersion(model.agentRuntimeVersion);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRuntimeEndpointRequest build() {
            return new CreateAgentRuntimeEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
