/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.BedrockAgentCoreControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DecryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EncryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottledException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UnauthorizedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetTokenVaultRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimeVersionsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListApiKeyCredentialProvidersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListBrowsersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListCodeInterpretersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListGatewayTargetsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListMemoriesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListOauth2CredentialProvidersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListWorkloadIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.SetTokenVaultCmkRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.BedrockAgentCoreControlWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link BedrockAgentCoreControlClient}.
 *
 * @see BedrockAgentCoreControlClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBedrockAgentCoreControlClient implements BedrockAgentCoreControlClient {
    private static final Logger log = Logger.loggerFor(DefaultBedrockAgentCoreControlClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBedrockAgentCoreControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Bedrock_AgentCore_Control" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     *
     * @param createAgentRuntimeRequest
     * @return Result of the CreateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAgentRuntimeResponse createAgentRuntime(CreateAgentRuntimeRequest createAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAgentRuntimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAgentRuntime");

            return clientHandler.execute(new ClientExecutionParams<CreateAgentRuntimeRequest, CreateAgentRuntimeResponse>()
                    .withOperationName("CreateAgentRuntime").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAgentRuntimeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAgentRuntimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     * @return Result of the CreateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAgentRuntimeEndpointResponse createAgentRuntimeEndpoint(
            CreateAgentRuntimeEndpointRequest createAgentRuntimeEndpointRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAgentRuntimeEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAgentRuntimeEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAgentRuntimeEndpointRequest, CreateAgentRuntimeEndpointResponse>()
                            .withOperationName("CreateAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAgentRuntimeEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAgentRuntimeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     * @return Result of the CreateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateApiKeyCredentialProviderResponse createApiKeyCredentialProvider(
            CreateApiKeyCredentialProviderRequest createApiKeyCredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ResourceLimitExceededException, ValidationException, ConflictException, AccessDeniedException,
            DecryptionFailureException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            EncryptionFailureException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateApiKeyCredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKeyCredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateApiKeyCredentialProviderRequest, CreateApiKeyCredentialProviderResponse>()
                            .withOperationName("CreateApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createApiKeyCredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateApiKeyCredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     *
     * @param createBrowserRequest
     * @return Result of the CreateBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBrowserResponse createBrowser(CreateBrowserRequest createBrowserRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBrowserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrowser");

            return clientHandler.execute(new ClientExecutionParams<CreateBrowserRequest, CreateBrowserResponse>()
                    .withOperationName("CreateBrowser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBrowserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBrowserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     *
     * @param createCodeInterpreterRequest
     * @return Result of the CreateCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCodeInterpreterResponse createCodeInterpreter(CreateCodeInterpreterRequest createCodeInterpreterRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCodeInterpreterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeInterpreter");

            return clientHandler.execute(new ClientExecutionParams<CreateCodeInterpreterRequest, CreateCodeInterpreterResponse>()
                    .withOperationName("CreateCodeInterpreter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCodeInterpreterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCodeInterpreterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                    .withOperationName("CreateGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     *
     * @param createGatewayTargetRequest
     * @return Result of the CreateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGatewayTargetResponse createGatewayTarget(CreateGatewayTargetRequest createGatewayTargetRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGatewayTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGatewayTarget");

            return clientHandler.execute(new ClientExecutionParams<CreateGatewayTargetRequest, CreateGatewayTargetResponse>()
                    .withOperationName("CreateGatewayTarget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGatewayTargetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGatewayTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     *
     * @param createMemoryRequest
     * @return Result of the CreateMemory operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMemoryResponse createMemory(CreateMemoryRequest createMemoryRequest) throws ServiceQuotaExceededException,
            ServiceException, ValidationException, AccessDeniedException, ConflictException, ResourceNotFoundException,
            ThrottledException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMemoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMemory");

            return clientHandler.execute(new ClientExecutionParams<CreateMemoryRequest, CreateMemoryResponse>()
                    .withOperationName("CreateMemory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMemoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMemoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     * @return Result of the CreateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOauth2CredentialProviderResponse createOauth2CredentialProvider(
            CreateOauth2CredentialProviderRequest createOauth2CredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ResourceLimitExceededException, ValidationException, ConflictException, AccessDeniedException,
            DecryptionFailureException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            EncryptionFailureException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateOauth2CredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOauth2CredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOauth2CredentialProviderRequest, CreateOauth2CredentialProviderResponse>()
                            .withOperationName("CreateOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createOauth2CredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateOauth2CredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     *
     * @param createWorkloadIdentityRequest
     * @return Result of the CreateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkloadIdentityResponse createWorkloadIdentity(CreateWorkloadIdentityRequest createWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkloadIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkloadIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateWorkloadIdentityRequest, CreateWorkloadIdentityResponse>()
                            .withOperationName("CreateWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createWorkloadIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateWorkloadIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     * @return Result of the DeleteAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAgentRuntimeResponse deleteAgentRuntime(DeleteAgentRuntimeRequest deleteAgentRuntimeRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAgentRuntimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAgentRuntime");

            return clientHandler.execute(new ClientExecutionParams<DeleteAgentRuntimeRequest, DeleteAgentRuntimeResponse>()
                    .withOperationName("DeleteAgentRuntime").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAgentRuntimeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAgentRuntimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     * @return Result of the DeleteAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAgentRuntimeEndpointResponse deleteAgentRuntimeEndpoint(
            DeleteAgentRuntimeEndpointRequest deleteAgentRuntimeEndpointRequest) throws AccessDeniedException, ConflictException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAgentRuntimeEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAgentRuntimeEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAgentRuntimeEndpointRequest, DeleteAgentRuntimeEndpointResponse>()
                            .withOperationName("DeleteAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAgentRuntimeEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAgentRuntimeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     * @return Result of the DeleteApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApiKeyCredentialProviderResponse deleteApiKeyCredentialProvider(
            DeleteApiKeyCredentialProviderRequest deleteApiKeyCredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApiKeyCredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKeyCredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteApiKeyCredentialProviderRequest, DeleteApiKeyCredentialProviderResponse>()
                            .withOperationName("DeleteApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteApiKeyCredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteApiKeyCredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     *
     * @param deleteBrowserRequest
     * @return Result of the DeleteBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBrowserResponse deleteBrowser(DeleteBrowserRequest deleteBrowserRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBrowserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrowser");

            return clientHandler.execute(new ClientExecutionParams<DeleteBrowserRequest, DeleteBrowserResponse>()
                    .withOperationName("DeleteBrowser").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBrowserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBrowserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     * @return Result of the DeleteCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCodeInterpreterResponse deleteCodeInterpreter(DeleteCodeInterpreterRequest deleteCodeInterpreterRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCodeInterpreterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeInterpreter");

            return clientHandler.execute(new ClientExecutionParams<DeleteCodeInterpreterRequest, DeleteCodeInterpreterResponse>()
                    .withOperationName("DeleteCodeInterpreter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCodeInterpreterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCodeInterpreterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                    .withOperationName("DeleteGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     *
     * @param deleteGatewayTargetRequest
     * @return Result of the DeleteGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGatewayTargetResponse deleteGatewayTarget(DeleteGatewayTargetRequest deleteGatewayTargetRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGatewayTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGatewayTarget");

            return clientHandler.execute(new ClientExecutionParams<DeleteGatewayTargetRequest, DeleteGatewayTargetResponse>()
                    .withOperationName("DeleteGatewayTarget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGatewayTargetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGatewayTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     *
     * @param deleteMemoryRequest
     * @return Result of the DeleteMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMemoryResponse deleteMemory(DeleteMemoryRequest deleteMemoryRequest) throws ServiceException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMemoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMemory");

            return clientHandler.execute(new ClientExecutionParams<DeleteMemoryRequest, DeleteMemoryResponse>()
                    .withOperationName("DeleteMemory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteMemoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMemoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     * @return Result of the DeleteOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOauth2CredentialProviderResponse deleteOauth2CredentialProvider(
            DeleteOauth2CredentialProviderRequest deleteOauth2CredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOauth2CredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOauth2CredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOauth2CredentialProviderRequest, DeleteOauth2CredentialProviderResponse>()
                            .withOperationName("DeleteOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOauth2CredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOauth2CredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     * @return Result of the DeleteWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkloadIdentityResponse deleteWorkloadIdentity(DeleteWorkloadIdentityRequest deleteWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkloadIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkloadIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkloadIdentityRequest, DeleteWorkloadIdentityResponse>()
                            .withOperationName("DeleteWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteWorkloadIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteWorkloadIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     *
     * @param getAgentRuntimeRequest
     * @return Result of the GetAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAgentRuntimeResponse getAgentRuntime(GetAgentRuntimeRequest getAgentRuntimeRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAgentRuntimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAgentRuntime");

            return clientHandler.execute(new ClientExecutionParams<GetAgentRuntimeRequest, GetAgentRuntimeResponse>()
                    .withOperationName("GetAgentRuntime").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAgentRuntimeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAgentRuntimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     * @return Result of the GetAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAgentRuntimeEndpointResponse getAgentRuntimeEndpoint(GetAgentRuntimeEndpointRequest getAgentRuntimeEndpointRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAgentRuntimeEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAgentRuntimeEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAgentRuntimeEndpointRequest, GetAgentRuntimeEndpointResponse>()
                            .withOperationName("GetAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAgentRuntimeEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAgentRuntimeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     * @return Result of the GetApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApiKeyCredentialProviderResponse getApiKeyCredentialProvider(
            GetApiKeyCredentialProviderRequest getApiKeyCredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApiKeyCredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeyCredentialProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKeyCredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApiKeyCredentialProviderRequest, GetApiKeyCredentialProviderResponse>()
                            .withOperationName("GetApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getApiKeyCredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApiKeyCredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     *
     * @param getBrowserRequest
     * @return Result of the GetBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBrowserResponse getBrowser(GetBrowserRequest getBrowserRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBrowserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBrowser");

            return clientHandler.execute(new ClientExecutionParams<GetBrowserRequest, GetBrowserResponse>()
                    .withOperationName("GetBrowser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getBrowserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBrowserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     *
     * @param getCodeInterpreterRequest
     * @return Result of the GetCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCodeInterpreterResponse getCodeInterpreter(GetCodeInterpreterRequest getCodeInterpreterRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCodeInterpreterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCodeInterpreter");

            return clientHandler.execute(new ClientExecutionParams<GetCodeInterpreterRequest, GetCodeInterpreterResponse>()
                    .withOperationName("GetCodeInterpreter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCodeInterpreterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCodeInterpreterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return Result of the GetGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGateway");

            return clientHandler.execute(new ClientExecutionParams<GetGatewayRequest, GetGatewayResponse>()
                    .withOperationName("GetGateway").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getGatewayRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     *
     * @param getGatewayTargetRequest
     * @return Result of the GetGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGatewayTargetResponse getGatewayTarget(GetGatewayTargetRequest getGatewayTargetRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGatewayTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayTarget");

            return clientHandler.execute(new ClientExecutionParams<GetGatewayTargetRequest, GetGatewayTargetResponse>()
                    .withOperationName("GetGatewayTarget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getGatewayTargetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGatewayTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     *
     * @param getMemoryRequest
     * @return Result of the GetMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMemoryResponse getMemory(GetMemoryRequest getMemoryRequest) throws ServiceException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMemoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMemory");

            return clientHandler.execute(new ClientExecutionParams<GetMemoryRequest, GetMemoryResponse>()
                    .withOperationName("GetMemory").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getMemoryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMemoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     * @return Result of the GetOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOauth2CredentialProviderResponse getOauth2CredentialProvider(
            GetOauth2CredentialProviderRequest getOauth2CredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOauth2CredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOauth2CredentialProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOauth2CredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOauth2CredentialProviderRequest, GetOauth2CredentialProviderResponse>()
                            .withOperationName("GetOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getOauth2CredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOauth2CredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     *
     * @param getTokenVaultRequest
     * @return Result of the GetTokenVault operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTokenVaultResponse getTokenVault(GetTokenVaultRequest getTokenVaultRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTokenVaultResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTokenVaultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTokenVaultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTokenVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTokenVault");

            return clientHandler.execute(new ClientExecutionParams<GetTokenVaultRequest, GetTokenVaultResponse>()
                    .withOperationName("GetTokenVault").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTokenVaultRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTokenVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     *
     * @param getWorkloadIdentityRequest
     * @return Result of the GetWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWorkloadIdentityResponse getWorkloadIdentity(GetWorkloadIdentityRequest getWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkloadIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkloadIdentity");

            return clientHandler.execute(new ClientExecutionParams<GetWorkloadIdentityRequest, GetWorkloadIdentityResponse>()
                    .withOperationName("GetWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkloadIdentityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkloadIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return Result of the ListAgentRuntimeEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAgentRuntimeEndpointsResponse listAgentRuntimeEndpoints(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAgentRuntimeEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAgentRuntimeEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimeEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimeEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAgentRuntimeEndpointsRequest, ListAgentRuntimeEndpointsResponse>()
                            .withOperationName("ListAgentRuntimeEndpoints").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAgentRuntimeEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAgentRuntimeEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return Result of the ListAgentRuntimeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAgentRuntimeVersionsResponse listAgentRuntimeVersions(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAgentRuntimeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAgentRuntimeVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimeVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimeVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAgentRuntimeVersionsRequest, ListAgentRuntimeVersionsResponse>()
                            .withOperationName("ListAgentRuntimeVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAgentRuntimeVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAgentRuntimeVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return Result of the ListAgentRuntimes operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAgentRuntimesResponse listAgentRuntimes(ListAgentRuntimesRequest listAgentRuntimesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAgentRuntimesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAgentRuntimesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimes");

            return clientHandler.execute(new ClientExecutionParams<ListAgentRuntimesRequest, ListAgentRuntimesResponse>()
                    .withOperationName("ListAgentRuntimes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAgentRuntimesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAgentRuntimesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return Result of the ListApiKeyCredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApiKeyCredentialProvidersResponse listApiKeyCredentialProviders(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApiKeyCredentialProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListApiKeyCredentialProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApiKeyCredentialProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listApiKeyCredentialProvidersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApiKeyCredentialProviders");

            return clientHandler
                    .execute(new ClientExecutionParams<ListApiKeyCredentialProvidersRequest, ListApiKeyCredentialProvidersResponse>()
                            .withOperationName("ListApiKeyCredentialProviders").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listApiKeyCredentialProvidersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListApiKeyCredentialProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     *
     * @param listBrowsersRequest
     * @return Result of the ListBrowsers operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBrowsersResponse listBrowsers(ListBrowsersRequest listBrowsersRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBrowsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBrowsersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBrowsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBrowsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBrowsers");

            return clientHandler.execute(new ClientExecutionParams<ListBrowsersRequest, ListBrowsersResponse>()
                    .withOperationName("ListBrowsers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBrowsersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBrowsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return Result of the ListCodeInterpreters operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCodeInterpretersResponse listCodeInterpreters(ListCodeInterpretersRequest listCodeInterpretersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCodeInterpretersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCodeInterpretersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCodeInterpretersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodeInterpretersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodeInterpreters");

            return clientHandler.execute(new ClientExecutionParams<ListCodeInterpretersRequest, ListCodeInterpretersResponse>()
                    .withOperationName("ListCodeInterpreters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCodeInterpretersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCodeInterpretersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return Result of the ListGatewayTargets operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGatewayTargetsResponse listGatewayTargets(ListGatewayTargetsRequest listGatewayTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewayTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGatewayTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewayTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewayTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGatewayTargets");

            return clientHandler.execute(new ClientExecutionParams<ListGatewayTargetsRequest, ListGatewayTargetsResponse>()
                    .withOperationName("ListGatewayTargets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGatewayTargetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGatewayTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGatewaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");

            return clientHandler.execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                    .withOperationName("ListGateways").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGatewaysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     *
     * @param listMemoriesRequest
     * @return Result of the ListMemories operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMemoriesResponse listMemories(ListMemoriesRequest listMemoriesRequest) throws ServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMemoriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMemoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMemoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMemoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMemories");

            return clientHandler.execute(new ClientExecutionParams<ListMemoriesRequest, ListMemoriesResponse>()
                    .withOperationName("ListMemories").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMemoriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMemoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return Result of the ListOauth2CredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOauth2CredentialProvidersResponse listOauth2CredentialProviders(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOauth2CredentialProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOauth2CredentialProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOauth2CredentialProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOauth2CredentialProvidersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOauth2CredentialProviders");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOauth2CredentialProvidersRequest, ListOauth2CredentialProvidersResponse>()
                            .withOperationName("ListOauth2CredentialProviders").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listOauth2CredentialProvidersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOauth2CredentialProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return Result of the ListWorkloadIdentities operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkloadIdentitiesResponse listWorkloadIdentities(ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkloadIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkloadIdentitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadIdentitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadIdentities");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWorkloadIdentitiesRequest, ListWorkloadIdentitiesResponse>()
                            .withOperationName("ListWorkloadIdentities").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWorkloadIdentitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWorkloadIdentitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     *
     * @param setTokenVaultCmkRequest
     * @return Result of the SetTokenVaultCMK operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ConcurrentModificationException
     *         Exception thrown when a resource is modified concurrently by multiple requests.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetTokenVaultCmkResponse setTokenVaultCMK(SetTokenVaultCmkRequest setTokenVaultCmkRequest)
            throws UnauthorizedException, ConcurrentModificationException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetTokenVaultCmkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SetTokenVaultCmkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setTokenVaultCmkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setTokenVaultCmkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTokenVaultCMK");

            return clientHandler.execute(new ClientExecutionParams<SetTokenVaultCmkRequest, SetTokenVaultCmkResponse>()
                    .withOperationName("SetTokenVaultCMK").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setTokenVaultCmkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetTokenVaultCmkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     *
     * @param updateAgentRuntimeRequest
     * @return Result of the UpdateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAgentRuntimeResponse updateAgentRuntime(UpdateAgentRuntimeRequest updateAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAgentRuntimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAgentRuntime");

            return clientHandler.execute(new ClientExecutionParams<UpdateAgentRuntimeRequest, UpdateAgentRuntimeResponse>()
                    .withOperationName("UpdateAgentRuntime").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAgentRuntimeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAgentRuntimeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     * @return Result of the UpdateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAgentRuntimeEndpointResponse updateAgentRuntimeEndpoint(
            UpdateAgentRuntimeEndpointRequest updateAgentRuntimeEndpointRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAgentRuntimeEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAgentRuntimeEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAgentRuntimeEndpointRequest, UpdateAgentRuntimeEndpointResponse>()
                            .withOperationName("UpdateAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAgentRuntimeEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAgentRuntimeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     * @return Result of the UpdateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApiKeyCredentialProviderResponse updateApiKeyCredentialProvider(
            UpdateApiKeyCredentialProviderRequest updateApiKeyCredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ValidationException, AccessDeniedException, ConflictException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, EncryptionFailureException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApiKeyCredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKeyCredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateApiKeyCredentialProviderRequest, UpdateApiKeyCredentialProviderResponse>()
                            .withOperationName("UpdateApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateApiKeyCredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateApiKeyCredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGateway");

            return clientHandler.execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                    .withOperationName("UpdateGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     *
     * @param updateGatewayTargetRequest
     * @return Result of the UpdateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGatewayTargetResponse updateGatewayTarget(UpdateGatewayTargetRequest updateGatewayTargetRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGatewayTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayTarget");

            return clientHandler.execute(new ClientExecutionParams<UpdateGatewayTargetRequest, UpdateGatewayTargetResponse>()
                    .withOperationName("UpdateGatewayTarget").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGatewayTargetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGatewayTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update memory.
     * </p>
     *
     * @param updateMemoryRequest
     * @return Result of the UpdateMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMemoryResponse updateMemory(UpdateMemoryRequest updateMemoryRequest) throws ServiceException,
            ServiceQuotaExceededException, ValidationException, AccessDeniedException, ConflictException,
            ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMemoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMemory");

            return clientHandler.execute(new ClientExecutionParams<UpdateMemoryRequest, UpdateMemoryResponse>()
                    .withOperationName("UpdateMemory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateMemoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMemoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     * @return Result of the UpdateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOauth2CredentialProviderResponse updateOauth2CredentialProvider(
            UpdateOauth2CredentialProviderRequest updateOauth2CredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ValidationException, AccessDeniedException, ConflictException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, EncryptionFailureException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateOauth2CredentialProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOauth2CredentialProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateOauth2CredentialProviderRequest, UpdateOauth2CredentialProviderResponse>()
                            .withOperationName("UpdateOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateOauth2CredentialProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateOauth2CredentialProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     * @return Result of the UpdateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkloadIdentityResponse updateWorkloadIdentity(UpdateWorkloadIdentityRequest updateWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkloadIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EncryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ThrottledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottledException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnauthorizedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(UnauthorizedException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "DecryptionFailure":
                return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                        .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkloadIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkloadIdentityRequest, UpdateWorkloadIdentityResponse>()
                            .withOperationName("UpdateWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateWorkloadIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateWorkloadIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link BedrockAgentCoreControlWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link BedrockAgentCoreControlWaiter}
     */
    @Override
    public BedrockAgentCoreControlWaiter waiter() {
        return BedrockAgentCoreControlWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BedrockAgentCoreControlServiceClientConfigurationBuilder serviceConfigBuilder = new BedrockAgentCoreControlServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BedrockAgentCoreControlException::builder).protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1");
    }

    @Override
    public final BedrockAgentCoreControlServiceClientConfiguration serviceClientConfiguration() {
        return new BedrockAgentCoreControlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
