/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.BedrockAgentCoreControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DecryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EncryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottledException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UnauthorizedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.CreateWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.DeleteWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetBrowserRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetTokenVaultRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.GetWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimeVersionsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListAgentRuntimesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListApiKeyCredentialProvidersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListBrowsersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListCodeInterpretersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListGatewayTargetsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListMemoriesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListOauth2CredentialProvidersRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.ListWorkloadIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.SetTokenVaultCmkRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateAgentRuntimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateApiKeyCredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateGatewayTargetRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateMemoryRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateOauth2CredentialProviderRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.transform.UpdateWorkloadIdentityRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.BedrockAgentCoreControlAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link BedrockAgentCoreControlAsyncClient}.
 *
 * @see BedrockAgentCoreControlAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBedrockAgentCoreControlAsyncClient implements BedrockAgentCoreControlAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultBedrockAgentCoreControlAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultBedrockAgentCoreControlAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Bedrock_AgentCore_Control" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     *
     * @param createAgentRuntimeRequest
     * @return A Java Future containing the result of the CreateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAgentRuntimeResponse> createAgentRuntime(CreateAgentRuntimeRequest createAgentRuntimeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAgentRuntime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAgentRuntimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAgentRuntimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAgentRuntimeRequest, CreateAgentRuntimeResponse>()
                            .withOperationName("CreateAgentRuntime").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAgentRuntimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAgentRuntimeRequest));
            CompletableFuture<CreateAgentRuntimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the CreateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAgentRuntimeEndpointResponse> createAgentRuntimeEndpoint(
            CreateAgentRuntimeEndpointRequest createAgentRuntimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAgentRuntimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAgentRuntimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAgentRuntimeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAgentRuntimeEndpointRequest, CreateAgentRuntimeEndpointResponse>()
                            .withOperationName("CreateAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAgentRuntimeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAgentRuntimeEndpointRequest));
            CompletableFuture<CreateAgentRuntimeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the CreateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateApiKeyCredentialProviderResponse> createApiKeyCredentialProvider(
            CreateApiKeyCredentialProviderRequest createApiKeyCredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKeyCredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateApiKeyCredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateApiKeyCredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApiKeyCredentialProviderRequest, CreateApiKeyCredentialProviderResponse>()
                            .withOperationName("CreateApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateApiKeyCredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createApiKeyCredentialProviderRequest));
            CompletableFuture<CreateApiKeyCredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     *
     * @param createBrowserRequest
     * @return A Java Future containing the result of the CreateBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBrowserResponse> createBrowser(CreateBrowserRequest createBrowserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrowser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBrowserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateBrowserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBrowserRequest, CreateBrowserResponse>()
                            .withOperationName("CreateBrowser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBrowserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBrowserRequest));
            CompletableFuture<CreateBrowserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     *
     * @param createCodeInterpreterRequest
     * @return A Java Future containing the result of the CreateCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCodeInterpreterResponse> createCodeInterpreter(
            CreateCodeInterpreterRequest createCodeInterpreterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeInterpreter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCodeInterpreterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCodeInterpreterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCodeInterpreterRequest, CreateCodeInterpreterResponse>()
                            .withOperationName("CreateCodeInterpreter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCodeInterpreterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCodeInterpreterRequest));
            CompletableFuture<CreateCodeInterpreterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGatewayRequest, CreateGatewayResponse>()
                            .withOperationName("CreateGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGatewayRequest));
            CompletableFuture<CreateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     *
     * @param createGatewayTargetRequest
     * @return A Java Future containing the result of the CreateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGatewayTargetResponse> createGatewayTarget(
            CreateGatewayTargetRequest createGatewayTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGatewayTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGatewayTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGatewayTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGatewayTargetRequest, CreateGatewayTargetResponse>()
                            .withOperationName("CreateGatewayTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGatewayTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGatewayTargetRequest));
            CompletableFuture<CreateGatewayTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     *
     * @param createMemoryRequest
     * @return A Java Future containing the result of the CreateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMemoryResponse> createMemory(CreateMemoryRequest createMemoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMemory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateMemoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMemoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMemoryRequest, CreateMemoryResponse>()
                            .withOperationName("CreateMemory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMemoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMemoryRequest));
            CompletableFuture<CreateMemoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the CreateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOauth2CredentialProviderResponse> createOauth2CredentialProvider(
            CreateOauth2CredentialProviderRequest createOauth2CredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOauth2CredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOauth2CredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateOauth2CredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOauth2CredentialProviderRequest, CreateOauth2CredentialProviderResponse>()
                            .withOperationName("CreateOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOauth2CredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOauth2CredentialProviderRequest));
            CompletableFuture<CreateOauth2CredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     *
     * @param createWorkloadIdentityRequest
     * @return A Java Future containing the result of the CreateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkloadIdentityResponse> createWorkloadIdentity(
            CreateWorkloadIdentityRequest createWorkloadIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkloadIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkloadIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateWorkloadIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkloadIdentityRequest, CreateWorkloadIdentityResponse>()
                            .withOperationName("CreateWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkloadIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorkloadIdentityRequest));
            CompletableFuture<CreateWorkloadIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     * @return A Java Future containing the result of the DeleteAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAgentRuntimeResponse> deleteAgentRuntime(DeleteAgentRuntimeRequest deleteAgentRuntimeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAgentRuntime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAgentRuntimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAgentRuntimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAgentRuntimeRequest, DeleteAgentRuntimeResponse>()
                            .withOperationName("DeleteAgentRuntime").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAgentRuntimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAgentRuntimeRequest));
            CompletableFuture<DeleteAgentRuntimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the DeleteAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAgentRuntimeEndpointResponse> deleteAgentRuntimeEndpoint(
            DeleteAgentRuntimeEndpointRequest deleteAgentRuntimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAgentRuntimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAgentRuntimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAgentRuntimeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAgentRuntimeEndpointRequest, DeleteAgentRuntimeEndpointResponse>()
                            .withOperationName("DeleteAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAgentRuntimeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAgentRuntimeEndpointRequest));
            CompletableFuture<DeleteAgentRuntimeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the DeleteApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApiKeyCredentialProviderResponse> deleteApiKeyCredentialProvider(
            DeleteApiKeyCredentialProviderRequest deleteApiKeyCredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKeyCredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApiKeyCredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteApiKeyCredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApiKeyCredentialProviderRequest, DeleteApiKeyCredentialProviderResponse>()
                            .withOperationName("DeleteApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApiKeyCredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApiKeyCredentialProviderRequest));
            CompletableFuture<DeleteApiKeyCredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     *
     * @param deleteBrowserRequest
     * @return A Java Future containing the result of the DeleteBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBrowserResponse> deleteBrowser(DeleteBrowserRequest deleteBrowserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrowser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBrowserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBrowserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBrowserRequest, DeleteBrowserResponse>()
                            .withOperationName("DeleteBrowser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBrowserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBrowserRequest));
            CompletableFuture<DeleteBrowserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     * @return A Java Future containing the result of the DeleteCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCodeInterpreterResponse> deleteCodeInterpreter(
            DeleteCodeInterpreterRequest deleteCodeInterpreterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeInterpreter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCodeInterpreterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCodeInterpreterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCodeInterpreterRequest, DeleteCodeInterpreterResponse>()
                            .withOperationName("DeleteCodeInterpreter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCodeInterpreterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCodeInterpreterRequest));
            CompletableFuture<DeleteCodeInterpreterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                            .withOperationName("DeleteGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGatewayRequest));
            CompletableFuture<DeleteGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     *
     * @param deleteGatewayTargetRequest
     * @return A Java Future containing the result of the DeleteGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayTargetResponse> deleteGatewayTarget(
            DeleteGatewayTargetRequest deleteGatewayTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGatewayTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGatewayTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGatewayTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayTargetRequest, DeleteGatewayTargetResponse>()
                            .withOperationName("DeleteGatewayTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGatewayTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGatewayTargetRequest));
            CompletableFuture<DeleteGatewayTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     *
     * @param deleteMemoryRequest
     * @return A Java Future containing the result of the DeleteMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMemoryResponse> deleteMemory(DeleteMemoryRequest deleteMemoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMemory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMemoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMemoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMemoryRequest, DeleteMemoryResponse>()
                            .withOperationName("DeleteMemory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMemoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMemoryRequest));
            CompletableFuture<DeleteMemoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the DeleteOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOauth2CredentialProviderResponse> deleteOauth2CredentialProvider(
            DeleteOauth2CredentialProviderRequest deleteOauth2CredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOauth2CredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOauth2CredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOauth2CredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOauth2CredentialProviderRequest, DeleteOauth2CredentialProviderResponse>()
                            .withOperationName("DeleteOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOauth2CredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOauth2CredentialProviderRequest));
            CompletableFuture<DeleteOauth2CredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     * @return A Java Future containing the result of the DeleteWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkloadIdentityResponse> deleteWorkloadIdentity(
            DeleteWorkloadIdentityRequest deleteWorkloadIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkloadIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkloadIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteWorkloadIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkloadIdentityRequest, DeleteWorkloadIdentityResponse>()
                            .withOperationName("DeleteWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkloadIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorkloadIdentityRequest));
            CompletableFuture<DeleteWorkloadIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     *
     * @param getAgentRuntimeRequest
     * @return A Java Future containing the result of the GetAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAgentRuntimeResponse> getAgentRuntime(GetAgentRuntimeRequest getAgentRuntimeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAgentRuntime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAgentRuntimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetAgentRuntimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAgentRuntimeRequest, GetAgentRuntimeResponse>()
                            .withOperationName("GetAgentRuntime").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAgentRuntimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAgentRuntimeRequest));
            CompletableFuture<GetAgentRuntimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the GetAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAgentRuntimeEndpointResponse> getAgentRuntimeEndpoint(
            GetAgentRuntimeEndpointRequest getAgentRuntimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAgentRuntimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAgentRuntimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetAgentRuntimeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAgentRuntimeEndpointRequest, GetAgentRuntimeEndpointResponse>()
                            .withOperationName("GetAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAgentRuntimeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAgentRuntimeEndpointRequest));
            CompletableFuture<GetAgentRuntimeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the GetApiKeyCredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApiKeyCredentialProviderResponse> getApiKeyCredentialProvider(
            GetApiKeyCredentialProviderRequest getApiKeyCredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeyCredentialProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKeyCredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApiKeyCredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetApiKeyCredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApiKeyCredentialProviderRequest, GetApiKeyCredentialProviderResponse>()
                            .withOperationName("GetApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApiKeyCredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApiKeyCredentialProviderRequest));
            CompletableFuture<GetApiKeyCredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     *
     * @param getBrowserRequest
     * @return A Java Future containing the result of the GetBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBrowserResponse> getBrowser(GetBrowserRequest getBrowserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBrowserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBrowserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBrowser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBrowserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBrowserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetBrowserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBrowserRequest, GetBrowserResponse>().withOperationName("GetBrowser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBrowserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBrowserRequest));
            CompletableFuture<GetBrowserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     *
     * @param getCodeInterpreterRequest
     * @return A Java Future containing the result of the GetCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCodeInterpreterResponse> getCodeInterpreter(GetCodeInterpreterRequest getCodeInterpreterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCodeInterpreterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCodeInterpreterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCodeInterpreter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCodeInterpreterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCodeInterpreterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCodeInterpreterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCodeInterpreterRequest, GetCodeInterpreterResponse>()
                            .withOperationName("GetCodeInterpreter").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCodeInterpreterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCodeInterpreterRequest));
            CompletableFuture<GetCodeInterpreterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGatewayResponse> getGateway(GetGatewayRequest getGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayRequest, GetGatewayResponse>().withOperationName("GetGateway")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGatewayRequest));
            CompletableFuture<GetGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     *
     * @param getGatewayTargetRequest
     * @return A Java Future containing the result of the GetGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGatewayTargetResponse> getGatewayTarget(GetGatewayTargetRequest getGatewayTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetGatewayTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayTargetRequest, GetGatewayTargetResponse>()
                            .withOperationName("GetGatewayTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGatewayTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGatewayTargetRequest));
            CompletableFuture<GetGatewayTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     *
     * @param getMemoryRequest
     * @return A Java Future containing the result of the GetMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMemoryResponse> getMemory(GetMemoryRequest getMemoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMemory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMemoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetMemoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMemoryRequest, GetMemoryResponse>().withOperationName("GetMemory")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMemoryRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMemoryRequest));
            CompletableFuture<GetMemoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the GetOauth2CredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOauth2CredentialProviderResponse> getOauth2CredentialProvider(
            GetOauth2CredentialProviderRequest getOauth2CredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOauth2CredentialProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOauth2CredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOauth2CredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOauth2CredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOauth2CredentialProviderRequest, GetOauth2CredentialProviderResponse>()
                            .withOperationName("GetOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOauth2CredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOauth2CredentialProviderRequest));
            CompletableFuture<GetOauth2CredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     *
     * @param getTokenVaultRequest
     * @return A Java Future containing the result of the GetTokenVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTokenVaultResponse> getTokenVault(GetTokenVaultRequest getTokenVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTokenVaultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTokenVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTokenVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTokenVaultResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTokenVaultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetTokenVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTokenVaultRequest, GetTokenVaultResponse>()
                            .withOperationName("GetTokenVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTokenVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTokenVaultRequest));
            CompletableFuture<GetTokenVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     *
     * @param getWorkloadIdentityRequest
     * @return A Java Future containing the result of the GetWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkloadIdentityResponse> getWorkloadIdentity(
            GetWorkloadIdentityRequest getWorkloadIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkloadIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorkloadIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetWorkloadIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkloadIdentityRequest, GetWorkloadIdentityResponse>()
                            .withOperationName("GetWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkloadIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorkloadIdentityRequest));
            CompletableFuture<GetWorkloadIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return A Java Future containing the result of the ListAgentRuntimeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAgentRuntimeEndpointsResponse> listAgentRuntimeEndpoints(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimeEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAgentRuntimeEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAgentRuntimeEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAgentRuntimeEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAgentRuntimeEndpointsRequest, ListAgentRuntimeEndpointsResponse>()
                            .withOperationName("ListAgentRuntimeEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAgentRuntimeEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAgentRuntimeEndpointsRequest));
            CompletableFuture<ListAgentRuntimeEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return A Java Future containing the result of the ListAgentRuntimeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAgentRuntimeVersionsResponse> listAgentRuntimeVersions(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimeVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimeVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAgentRuntimeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAgentRuntimeVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAgentRuntimeVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAgentRuntimeVersionsRequest, ListAgentRuntimeVersionsResponse>()
                            .withOperationName("ListAgentRuntimeVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAgentRuntimeVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAgentRuntimeVersionsRequest));
            CompletableFuture<ListAgentRuntimeVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return A Java Future containing the result of the ListAgentRuntimes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAgentRuntimesResponse> listAgentRuntimes(ListAgentRuntimesRequest listAgentRuntimesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAgentRuntimesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAgentRuntimesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAgentRuntimes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAgentRuntimesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAgentRuntimesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAgentRuntimesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAgentRuntimesRequest, ListAgentRuntimesResponse>()
                            .withOperationName("ListAgentRuntimes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAgentRuntimesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAgentRuntimesRequest));
            CompletableFuture<ListAgentRuntimesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return A Java Future containing the result of the ListApiKeyCredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListApiKeyCredentialProvidersResponse> listApiKeyCredentialProviders(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApiKeyCredentialProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listApiKeyCredentialProvidersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApiKeyCredentialProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListApiKeyCredentialProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListApiKeyCredentialProvidersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListApiKeyCredentialProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListApiKeyCredentialProvidersRequest, ListApiKeyCredentialProvidersResponse>()
                            .withOperationName("ListApiKeyCredentialProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListApiKeyCredentialProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listApiKeyCredentialProvidersRequest));
            CompletableFuture<ListApiKeyCredentialProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     *
     * @param listBrowsersRequest
     * @return A Java Future containing the result of the ListBrowsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBrowsersResponse> listBrowsers(ListBrowsersRequest listBrowsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBrowsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBrowsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBrowsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBrowsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBrowsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBrowsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBrowsersRequest, ListBrowsersResponse>()
                            .withOperationName("ListBrowsers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBrowsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBrowsersRequest));
            CompletableFuture<ListBrowsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return A Java Future containing the result of the ListCodeInterpreters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCodeInterpretersResponse> listCodeInterpreters(
            ListCodeInterpretersRequest listCodeInterpretersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCodeInterpretersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodeInterpretersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodeInterpreters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCodeInterpretersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCodeInterpretersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCodeInterpretersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCodeInterpretersRequest, ListCodeInterpretersResponse>()
                            .withOperationName("ListCodeInterpreters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCodeInterpretersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCodeInterpretersRequest));
            CompletableFuture<ListCodeInterpretersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return A Java Future containing the result of the ListGatewayTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewayTargetsResponse> listGatewayTargets(ListGatewayTargetsRequest listGatewayTargetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewayTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewayTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGatewayTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewayTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGatewayTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGatewayTargetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewayTargetsRequest, ListGatewayTargetsResponse>()
                            .withOperationName("ListGatewayTargets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGatewayTargetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGatewayTargetsRequest));
            CompletableFuture<ListGatewayTargetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                            .withOperationName("ListGateways").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGatewaysRequest));
            CompletableFuture<ListGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     *
     * @param listMemoriesRequest
     * @return A Java Future containing the result of the ListMemories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMemoriesResponse> listMemories(ListMemoriesRequest listMemoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMemoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMemoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMemories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMemoriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMemoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMemoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMemoriesRequest, ListMemoriesResponse>()
                            .withOperationName("ListMemories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMemoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMemoriesRequest));
            CompletableFuture<ListMemoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return A Java Future containing the result of the ListOauth2CredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOauth2CredentialProvidersResponse> listOauth2CredentialProviders(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOauth2CredentialProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOauth2CredentialProvidersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOauth2CredentialProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOauth2CredentialProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOauth2CredentialProvidersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOauth2CredentialProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOauth2CredentialProvidersRequest, ListOauth2CredentialProvidersResponse>()
                            .withOperationName("ListOauth2CredentialProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOauth2CredentialProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOauth2CredentialProvidersRequest));
            CompletableFuture<ListOauth2CredentialProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return A Java Future containing the result of the ListWorkloadIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkloadIdentitiesResponse> listWorkloadIdentities(
            ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadIdentitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkloadIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkloadIdentitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListWorkloadIdentitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkloadIdentitiesRequest, ListWorkloadIdentitiesResponse>()
                            .withOperationName("ListWorkloadIdentities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkloadIdentitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorkloadIdentitiesRequest));
            CompletableFuture<ListWorkloadIdentitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     *
     * @param setTokenVaultCmkRequest
     * @return A Java Future containing the result of the SetTokenVaultCMK operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ConcurrentModificationException Exception thrown when a resource is modified concurrently by multiple
     *         requests.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetTokenVaultCmkResponse> setTokenVaultCMK(SetTokenVaultCmkRequest setTokenVaultCmkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setTokenVaultCmkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setTokenVaultCmkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTokenVaultCMK");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetTokenVaultCmkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetTokenVaultCmkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<SetTokenVaultCmkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetTokenVaultCmkRequest, SetTokenVaultCmkResponse>()
                            .withOperationName("SetTokenVaultCMK").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetTokenVaultCmkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setTokenVaultCmkRequest));
            CompletableFuture<SetTokenVaultCmkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     *
     * @param updateAgentRuntimeRequest
     * @return A Java Future containing the result of the UpdateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAgentRuntimeResponse> updateAgentRuntime(UpdateAgentRuntimeRequest updateAgentRuntimeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAgentRuntimeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAgentRuntimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAgentRuntime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAgentRuntimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAgentRuntimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateAgentRuntimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAgentRuntimeRequest, UpdateAgentRuntimeResponse>()
                            .withOperationName("UpdateAgentRuntime").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAgentRuntimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAgentRuntimeRequest));
            CompletableFuture<UpdateAgentRuntimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the UpdateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAgentRuntimeEndpointResponse> updateAgentRuntimeEndpoint(
            UpdateAgentRuntimeEndpointRequest updateAgentRuntimeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAgentRuntimeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAgentRuntimeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAgentRuntimeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAgentRuntimeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAgentRuntimeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateAgentRuntimeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAgentRuntimeEndpointRequest, UpdateAgentRuntimeEndpointResponse>()
                            .withOperationName("UpdateAgentRuntimeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAgentRuntimeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAgentRuntimeEndpointRequest));
            CompletableFuture<UpdateAgentRuntimeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the UpdateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApiKeyCredentialProviderResponse> updateApiKeyCredentialProvider(
            UpdateApiKeyCredentialProviderRequest updateApiKeyCredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApiKeyCredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateApiKeyCredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKeyCredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApiKeyCredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApiKeyCredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateApiKeyCredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApiKeyCredentialProviderRequest, UpdateApiKeyCredentialProviderResponse>()
                            .withOperationName("UpdateApiKeyCredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApiKeyCredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApiKeyCredentialProviderRequest));
            CompletableFuture<UpdateApiKeyCredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                            .withOperationName("UpdateGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGatewayRequest));
            CompletableFuture<UpdateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     *
     * @param updateGatewayTargetRequest
     * @return A Java Future containing the result of the UpdateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayTargetResponse> updateGatewayTarget(
            UpdateGatewayTargetRequest updateGatewayTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateGatewayTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayTargetRequest, UpdateGatewayTargetResponse>()
                            .withOperationName("UpdateGatewayTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGatewayTargetRequest));
            CompletableFuture<UpdateGatewayTargetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update memory.
     * </p>
     *
     * @param updateMemoryRequest
     * @return A Java Future containing the result of the UpdateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMemoryResponse> updateMemory(UpdateMemoryRequest updateMemoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMemoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMemoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMemory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMemoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateMemoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateMemoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMemoryRequest, UpdateMemoryResponse>()
                            .withOperationName("UpdateMemory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMemoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMemoryRequest));
            CompletableFuture<UpdateMemoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the UpdateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOauth2CredentialProviderResponse> updateOauth2CredentialProvider(
            UpdateOauth2CredentialProviderRequest updateOauth2CredentialProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOauth2CredentialProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOauth2CredentialProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOauth2CredentialProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOauth2CredentialProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOauth2CredentialProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateOauth2CredentialProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOauth2CredentialProviderRequest, UpdateOauth2CredentialProviderResponse>()
                            .withOperationName("UpdateOauth2CredentialProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOauth2CredentialProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOauth2CredentialProviderRequest));
            CompletableFuture<UpdateOauth2CredentialProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     * @return A Java Future containing the result of the UpdateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkloadIdentityResponse> updateWorkloadIdentity(
            UpdateWorkloadIdentityRequest updateWorkloadIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkloadIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkloadIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Bedrock AgentCore Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkloadIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkloadIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkloadIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(409).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "EncryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(EncryptionFailureException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "ThrottledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottledException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "UnauthorizedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(401)
                            .exceptionBuilderSupplier(UnauthorizedException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "DecryptionFailure":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DecryptionFailure").httpStatusCode(400)
                            .exceptionBuilderSupplier(DecryptionFailureException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateWorkloadIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkloadIdentityRequest, UpdateWorkloadIdentityResponse>()
                            .withOperationName("UpdateWorkloadIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkloadIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWorkloadIdentityRequest));
            CompletableFuture<UpdateWorkloadIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public BedrockAgentCoreControlAsyncWaiter waiter() {
        return BedrockAgentCoreControlAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final BedrockAgentCoreControlServiceClientConfiguration serviceClientConfiguration() {
        return new BedrockAgentCoreControlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BedrockAgentCoreControlException::builder).protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BedrockAgentCoreControlServiceClientConfigurationBuilder serviceConfigBuilder = new BedrockAgentCoreControlServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
