/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;

public class ListAgentRuntimesPublisher
implements SdkPublisher<ListAgentRuntimesResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListAgentRuntimesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentRuntimesPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentRuntimesPublisher(BedrockAgentCoreControlAsyncClient client, ListAgentRuntimesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentRuntimesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentRuntimesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Agent> agentRuntimes() {
        Function<ListAgentRuntimesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentRuntimes() != null) {
                return response.agentRuntimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentRuntimesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentRuntimesResponseFetcher
    implements AsyncPageFetcher<ListAgentRuntimesResponse> {
        private ListAgentRuntimesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentRuntimesResponse> nextPage(ListAgentRuntimesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimesPublisher.this.client.listAgentRuntimes(ListAgentRuntimesPublisher.this.firstRequest);
            }
            return ListAgentRuntimesPublisher.this.client.listAgentRuntimes((ListAgentRuntimesRequest)((Object)ListAgentRuntimesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

