/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ContainerConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentArtifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentArtifact> {
    private static final SdkField<ContainerConfiguration> CONTAINER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerConfiguration").getter(AgentArtifact.getter(AgentArtifact::containerConfiguration)).setter(AgentArtifact.setter(Builder::containerConfiguration)).constructor(ContainerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentArtifact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContainerConfiguration containerConfiguration;
    private final Type type;

    private AgentArtifact(BuilderImpl builder) {
        this.containerConfiguration = builder.containerConfiguration;
        this.type = builder.type;
    }

    public final ContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentArtifact)) {
            return false;
        }
        AgentArtifact other = (AgentArtifact)obj;
        return Objects.equals(this.containerConfiguration(), other.containerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AgentArtifact").add("ContainerConfiguration", (Object)this.containerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.containerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static AgentArtifact fromContainerConfiguration(ContainerConfiguration containerConfiguration) {
        return (AgentArtifact)AgentArtifact.builder().containerConfiguration(containerConfiguration).build();
    }

    public static AgentArtifact fromContainerConfiguration(Consumer<ContainerConfiguration.Builder> containerConfiguration) {
        ContainerConfiguration.Builder builder = ContainerConfiguration.builder();
        containerConfiguration.accept(builder);
        return AgentArtifact.fromContainerConfiguration((ContainerConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ContainerConfiguration>> map = new HashMap<String, SdkField<ContainerConfiguration>>();
        map.put("containerConfiguration", CONTAINER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentArtifact, T> g) {
        return obj -> g.apply((AgentArtifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTAINER_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContainerConfiguration containerConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AgentArtifact model) {
            this.containerConfiguration(model.containerConfiguration);
        }

        public final ContainerConfiguration.Builder getContainerConfiguration() {
            return this.containerConfiguration != null ? this.containerConfiguration.toBuilder() : null;
        }

        public final void setContainerConfiguration(ContainerConfiguration.BuilderImpl containerConfiguration) {
            ContainerConfiguration oldValue = this.containerConfiguration;
            this.containerConfiguration = containerConfiguration != null ? containerConfiguration.build() : null;
            this.handleUnionValueChange(Type.CONTAINER_CONFIGURATION, oldValue, this.containerConfiguration);
        }

        @Override
        public final Builder containerConfiguration(ContainerConfiguration containerConfiguration) {
            ContainerConfiguration oldValue = this.containerConfiguration;
            this.containerConfiguration = containerConfiguration;
            this.handleUnionValueChange(Type.CONTAINER_CONFIGURATION, oldValue, this.containerConfiguration);
            return this;
        }

        public AgentArtifact build() {
            return new AgentArtifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentArtifact> {
        public Builder containerConfiguration(ContainerConfiguration var1);

        default public Builder containerConfiguration(Consumer<ContainerConfiguration.Builder> containerConfiguration) {
            return this.containerConfiguration((ContainerConfiguration)((ContainerConfiguration.Builder)ContainerConfiguration.builder().applyMutation(containerConfiguration)).build());
        }
    }
}

