/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SemanticOverrideConfigurationInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SummaryOverrideConfigurationInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UserPreferenceOverrideConfigurationInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConfigurationInput> {
    private static final SdkField<SemanticOverrideConfigurationInput> SEMANTIC_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("semanticOverride").getter(CustomConfigurationInput.getter(CustomConfigurationInput::semanticOverride)).setter(CustomConfigurationInput.setter(Builder::semanticOverride)).constructor(SemanticOverrideConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticOverride").build()}).build();
    private static final SdkField<SummaryOverrideConfigurationInput> SUMMARY_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summaryOverride").getter(CustomConfigurationInput.getter(CustomConfigurationInput::summaryOverride)).setter(CustomConfigurationInput.setter(Builder::summaryOverride)).constructor(SummaryOverrideConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryOverride").build()}).build();
    private static final SdkField<UserPreferenceOverrideConfigurationInput> USER_PREFERENCE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPreferenceOverride").getter(CustomConfigurationInput.getter(CustomConfigurationInput::userPreferenceOverride)).setter(CustomConfigurationInput.setter(Builder::userPreferenceOverride)).constructor(UserPreferenceOverrideConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_OVERRIDE_FIELD, SUMMARY_OVERRIDE_FIELD, USER_PREFERENCE_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SemanticOverrideConfigurationInput semanticOverride;
    private final SummaryOverrideConfigurationInput summaryOverride;
    private final UserPreferenceOverrideConfigurationInput userPreferenceOverride;
    private final Type type;

    private CustomConfigurationInput(BuilderImpl builder) {
        this.semanticOverride = builder.semanticOverride;
        this.summaryOverride = builder.summaryOverride;
        this.userPreferenceOverride = builder.userPreferenceOverride;
        this.type = builder.type;
    }

    public final SemanticOverrideConfigurationInput semanticOverride() {
        return this.semanticOverride;
    }

    public final SummaryOverrideConfigurationInput summaryOverride() {
        return this.summaryOverride;
    }

    public final UserPreferenceOverrideConfigurationInput userPreferenceOverride() {
        return this.userPreferenceOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPreferenceOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConfigurationInput)) {
            return false;
        }
        CustomConfigurationInput other = (CustomConfigurationInput)obj;
        return Objects.equals(this.semanticOverride(), other.semanticOverride()) && Objects.equals(this.summaryOverride(), other.summaryOverride()) && Objects.equals(this.userPreferenceOverride(), other.userPreferenceOverride());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConfigurationInput").add("SemanticOverride", (Object)this.semanticOverride()).add("SummaryOverride", (Object)this.summaryOverride()).add("UserPreferenceOverride", (Object)this.userPreferenceOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "semanticOverride": {
                return Optional.ofNullable(clazz.cast(this.semanticOverride()));
            }
            case "summaryOverride": {
                return Optional.ofNullable(clazz.cast(this.summaryOverride()));
            }
            case "userPreferenceOverride": {
                return Optional.ofNullable(clazz.cast(this.userPreferenceOverride()));
            }
        }
        return Optional.empty();
    }

    public static CustomConfigurationInput fromSemanticOverride(SemanticOverrideConfigurationInput semanticOverride) {
        return (CustomConfigurationInput)CustomConfigurationInput.builder().semanticOverride(semanticOverride).build();
    }

    public static CustomConfigurationInput fromSemanticOverride(Consumer<SemanticOverrideConfigurationInput.Builder> semanticOverride) {
        SemanticOverrideConfigurationInput.Builder builder = SemanticOverrideConfigurationInput.builder();
        semanticOverride.accept(builder);
        return CustomConfigurationInput.fromSemanticOverride((SemanticOverrideConfigurationInput)builder.build());
    }

    public static CustomConfigurationInput fromSummaryOverride(SummaryOverrideConfigurationInput summaryOverride) {
        return (CustomConfigurationInput)CustomConfigurationInput.builder().summaryOverride(summaryOverride).build();
    }

    public static CustomConfigurationInput fromSummaryOverride(Consumer<SummaryOverrideConfigurationInput.Builder> summaryOverride) {
        SummaryOverrideConfigurationInput.Builder builder = SummaryOverrideConfigurationInput.builder();
        summaryOverride.accept(builder);
        return CustomConfigurationInput.fromSummaryOverride((SummaryOverrideConfigurationInput)builder.build());
    }

    public static CustomConfigurationInput fromUserPreferenceOverride(UserPreferenceOverrideConfigurationInput userPreferenceOverride) {
        return (CustomConfigurationInput)CustomConfigurationInput.builder().userPreferenceOverride(userPreferenceOverride).build();
    }

    public static CustomConfigurationInput fromUserPreferenceOverride(Consumer<UserPreferenceOverrideConfigurationInput.Builder> userPreferenceOverride) {
        UserPreferenceOverrideConfigurationInput.Builder builder = UserPreferenceOverrideConfigurationInput.builder();
        userPreferenceOverride.accept(builder);
        return CustomConfigurationInput.fromUserPreferenceOverride((UserPreferenceOverrideConfigurationInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semanticOverride", SEMANTIC_OVERRIDE_FIELD);
        map.put("summaryOverride", SUMMARY_OVERRIDE_FIELD);
        map.put("userPreferenceOverride", USER_PREFERENCE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConfigurationInput, T> g) {
        return obj -> g.apply((CustomConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SEMANTIC_OVERRIDE,
        SUMMARY_OVERRIDE,
        USER_PREFERENCE_OVERRIDE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SemanticOverrideConfigurationInput semanticOverride;
        private SummaryOverrideConfigurationInput summaryOverride;
        private UserPreferenceOverrideConfigurationInput userPreferenceOverride;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConfigurationInput model) {
            this.semanticOverride(model.semanticOverride);
            this.summaryOverride(model.summaryOverride);
            this.userPreferenceOverride(model.userPreferenceOverride);
        }

        public final SemanticOverrideConfigurationInput.Builder getSemanticOverride() {
            return this.semanticOverride != null ? this.semanticOverride.toBuilder() : null;
        }

        public final void setSemanticOverride(SemanticOverrideConfigurationInput.BuilderImpl semanticOverride) {
            SemanticOverrideConfigurationInput oldValue = this.semanticOverride;
            this.semanticOverride = semanticOverride != null ? semanticOverride.build() : null;
            this.handleUnionValueChange(Type.SEMANTIC_OVERRIDE, oldValue, this.semanticOverride);
        }

        @Override
        public final Builder semanticOverride(SemanticOverrideConfigurationInput semanticOverride) {
            SemanticOverrideConfigurationInput oldValue = this.semanticOverride;
            this.semanticOverride = semanticOverride;
            this.handleUnionValueChange(Type.SEMANTIC_OVERRIDE, oldValue, this.semanticOverride);
            return this;
        }

        public final SummaryOverrideConfigurationInput.Builder getSummaryOverride() {
            return this.summaryOverride != null ? this.summaryOverride.toBuilder() : null;
        }

        public final void setSummaryOverride(SummaryOverrideConfigurationInput.BuilderImpl summaryOverride) {
            SummaryOverrideConfigurationInput oldValue = this.summaryOverride;
            this.summaryOverride = summaryOverride != null ? summaryOverride.build() : null;
            this.handleUnionValueChange(Type.SUMMARY_OVERRIDE, oldValue, this.summaryOverride);
        }

        @Override
        public final Builder summaryOverride(SummaryOverrideConfigurationInput summaryOverride) {
            SummaryOverrideConfigurationInput oldValue = this.summaryOverride;
            this.summaryOverride = summaryOverride;
            this.handleUnionValueChange(Type.SUMMARY_OVERRIDE, oldValue, this.summaryOverride);
            return this;
        }

        public final UserPreferenceOverrideConfigurationInput.Builder getUserPreferenceOverride() {
            return this.userPreferenceOverride != null ? this.userPreferenceOverride.toBuilder() : null;
        }

        public final void setUserPreferenceOverride(UserPreferenceOverrideConfigurationInput.BuilderImpl userPreferenceOverride) {
            UserPreferenceOverrideConfigurationInput oldValue = this.userPreferenceOverride;
            this.userPreferenceOverride = userPreferenceOverride != null ? userPreferenceOverride.build() : null;
            this.handleUnionValueChange(Type.USER_PREFERENCE_OVERRIDE, oldValue, this.userPreferenceOverride);
        }

        @Override
        public final Builder userPreferenceOverride(UserPreferenceOverrideConfigurationInput userPreferenceOverride) {
            UserPreferenceOverrideConfigurationInput oldValue = this.userPreferenceOverride;
            this.userPreferenceOverride = userPreferenceOverride;
            this.handleUnionValueChange(Type.USER_PREFERENCE_OVERRIDE, oldValue, this.userPreferenceOverride);
            return this;
        }

        public CustomConfigurationInput build() {
            return new CustomConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConfigurationInput> {
        public Builder semanticOverride(SemanticOverrideConfigurationInput var1);

        default public Builder semanticOverride(Consumer<SemanticOverrideConfigurationInput.Builder> semanticOverride) {
            return this.semanticOverride((SemanticOverrideConfigurationInput)((SemanticOverrideConfigurationInput.Builder)SemanticOverrideConfigurationInput.builder().applyMutation(semanticOverride)).build());
        }

        public Builder summaryOverride(SummaryOverrideConfigurationInput var1);

        default public Builder summaryOverride(Consumer<SummaryOverrideConfigurationInput.Builder> summaryOverride) {
            return this.summaryOverride((SummaryOverrideConfigurationInput)((SummaryOverrideConfigurationInput.Builder)SummaryOverrideConfigurationInput.builder().applyMutation(summaryOverride)).build());
        }

        public Builder userPreferenceOverride(UserPreferenceOverrideConfigurationInput var1);

        default public Builder userPreferenceOverride(Consumer<UserPreferenceOverrideConfigurationInput.Builder> userPreferenceOverride) {
            return this.userPreferenceOverride((UserPreferenceOverrideConfigurationInput)((UserPreferenceOverrideConfigurationInput.Builder)UserPreferenceOverrideConfigurationInput.builder().applyMutation(userPreferenceOverride)).build());
        }
    }
}

