/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeInterpreterSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;

public class ListCodeInterpretersIterable
implements SdkIterable<ListCodeInterpretersResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListCodeInterpretersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCodeInterpretersIterable(BedrockAgentCoreControlClient client, ListCodeInterpretersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCodeInterpretersResponseFetcher();
    }

    public Iterator<ListCodeInterpretersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CodeInterpreterSummary> codeInterpreterSummaries() {
        Function<ListCodeInterpretersResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeInterpreterSummaries() != null) {
                return response.codeInterpreterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCodeInterpretersResponseFetcher
    implements SyncPageFetcher<ListCodeInterpretersResponse> {
        private ListCodeInterpretersResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeInterpretersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCodeInterpretersResponse nextPage(ListCodeInterpretersResponse previousPage) {
            if (previousPage == null) {
                return ListCodeInterpretersIterable.this.client.listCodeInterpreters(ListCodeInterpretersIterable.this.firstRequest);
            }
            return ListCodeInterpretersIterable.this.client.listCodeInterpreters((ListCodeInterpretersRequest)((Object)ListCodeInterpretersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

