/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.ActorSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.ActorSummaryListCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActorsResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, ListActorsResponse> {
    private static final SdkField<List<ActorSummary>> ACTOR_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actorSummaries").getter(ListActorsResponse.getter(ListActorsResponse::actorSummaries)).setter(ListActorsResponse.setter(Builder::actorSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActorsResponse.getter(ListActorsResponse::nextToken)).setter(ListActorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTOR_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActorsResponse.memberNameToFieldInitializer();
    private final List<ActorSummary> actorSummaries;
    private final String nextToken;

    private ListActorsResponse(BuilderImpl builder) {
        super(builder);
        this.actorSummaries = builder.actorSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActorSummaries() {
        return this.actorSummaries != null && !(this.actorSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActorSummary> actorSummaries() {
        return this.actorSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActorSummaries() ? this.actorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActorsResponse)) {
            return false;
        }
        ListActorsResponse other = (ListActorsResponse)((Object)obj);
        return this.hasActorSummaries() == other.hasActorSummaries() && Objects.equals(this.actorSummaries(), other.actorSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActorsResponse").add("ActorSummaries", this.hasActorSummaries() ? this.actorSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actorSummaries": {
                return Optional.ofNullable(clazz.cast(this.actorSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actorSummaries", ACTOR_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActorsResponse, T> g) {
        return obj -> g.apply((ListActorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private List<ActorSummary> actorSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActorsResponse model) {
            super(model);
            this.actorSummaries(model.actorSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ActorSummary.Builder> getActorSummaries() {
            List<ActorSummary.Builder> result = ActorSummaryListCopier.copyToBuilder(this.actorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActorSummaries(Collection<ActorSummary.BuilderImpl> actorSummaries) {
            this.actorSummaries = ActorSummaryListCopier.copyFromBuilder(actorSummaries);
        }

        @Override
        public final Builder actorSummaries(Collection<ActorSummary> actorSummaries) {
            this.actorSummaries = ActorSummaryListCopier.copy(actorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actorSummaries(ActorSummary ... actorSummaries) {
            this.actorSummaries(Arrays.asList(actorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actorSummaries(Consumer<ActorSummary.Builder> ... actorSummaries) {
            this.actorSummaries(Stream.of(actorSummaries).map(c -> (ActorSummary)((ActorSummary.Builder)ActorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActorsResponse build() {
            return new ListActorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActorsResponse> {
        public Builder actorSummaries(Collection<ActorSummary> var1);

        public Builder actorSummaries(ActorSummary ... var1);

        public Builder actorSummaries(Consumer<ActorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

