/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryContent;
import software.amazon.awssdk.services.bedrockagentcore.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryRecordUpdateInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryRecordUpdateInput> {
    private static final SdkField<String> MEMORY_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryRecordId").getter(MemoryRecordUpdateInput.getter(MemoryRecordUpdateInput::memoryRecordId)).setter(MemoryRecordUpdateInput.setter(Builder::memoryRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRecordId").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(MemoryRecordUpdateInput.getter(MemoryRecordUpdateInput::timestamp)).setter(MemoryRecordUpdateInput.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<MemoryContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(MemoryRecordUpdateInput.getter(MemoryRecordUpdateInput::content)).setter(MemoryRecordUpdateInput.setter(Builder::content)).constructor(MemoryContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(MemoryRecordUpdateInput.getter(MemoryRecordUpdateInput::namespaces)).setter(MemoryRecordUpdateInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(MemoryRecordUpdateInput.getter(MemoryRecordUpdateInput::memoryStrategyId)).setter(MemoryRecordUpdateInput.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_RECORD_ID_FIELD, TIMESTAMP_FIELD, CONTENT_FIELD, NAMESPACES_FIELD, MEMORY_STRATEGY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemoryRecordUpdateInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memoryRecordId;
    private final Instant timestamp;
    private final MemoryContent content;
    private final List<String> namespaces;
    private final String memoryStrategyId;

    private MemoryRecordUpdateInput(BuilderImpl builder) {
        this.memoryRecordId = builder.memoryRecordId;
        this.timestamp = builder.timestamp;
        this.content = builder.content;
        this.namespaces = builder.namespaces;
        this.memoryStrategyId = builder.memoryStrategyId;
    }

    public final String memoryRecordId() {
        return this.memoryRecordId;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final MemoryContent content() {
        return this.content;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryRecordUpdateInput)) {
            return false;
        }
        MemoryRecordUpdateInput other = (MemoryRecordUpdateInput)obj;
        return Objects.equals(this.memoryRecordId(), other.memoryRecordId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.content(), other.content()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryRecordUpdateInput").add("MemoryRecordId", (Object)this.memoryRecordId()).add("Timestamp", (Object)this.timestamp()).add("Content", (Object)this.content()).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("MemoryStrategyId", (Object)this.memoryStrategyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryRecordId": {
                return Optional.ofNullable(clazz.cast(this.memoryRecordId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryRecordId", MEMORY_RECORD_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryRecordUpdateInput, T> g) {
        return obj -> g.apply((MemoryRecordUpdateInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memoryRecordId;
        private Instant timestamp;
        private MemoryContent content;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private String memoryStrategyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryRecordUpdateInput model) {
            this.memoryRecordId(model.memoryRecordId);
            this.timestamp(model.timestamp);
            this.content(model.content);
            this.namespaces(model.namespaces);
            this.memoryStrategyId(model.memoryStrategyId);
        }

        public final String getMemoryRecordId() {
            return this.memoryRecordId;
        }

        public final void setMemoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
        }

        @Override
        public final Builder memoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final MemoryContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MemoryContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MemoryContent content) {
            this.content = content;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public MemoryRecordUpdateInput build() {
            return new MemoryRecordUpdateInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryRecordUpdateInput> {
        public Builder memoryRecordId(String var1);

        public Builder timestamp(Instant var1);

        public Builder content(MemoryContent var1);

        default public Builder content(Consumer<MemoryContent.Builder> content) {
            return this.content((MemoryContent)((MemoryContent.Builder)MemoryContent.builder().applyMutation(content)).build());
        }

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder memoryStrategyId(String var1);
    }
}

