/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.EvaluationInput;
import software.amazon.awssdk.services.bedrockagentcore.model.EvaluationTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, EvaluateRequest> {
    private static final SdkField<String> EVALUATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorId").getter(EvaluateRequest.getter(EvaluateRequest::evaluatorId)).setter(EvaluateRequest.setter(Builder::evaluatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("evaluatorId").build()}).build();
    private static final SdkField<EvaluationInput> EVALUATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluationInput").getter(EvaluateRequest.getter(EvaluateRequest::evaluationInput)).setter(EvaluateRequest.setter(Builder::evaluationInput)).constructor(EvaluationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationInput").build()}).build();
    private static final SdkField<EvaluationTarget> EVALUATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluationTarget").getter(EvaluateRequest.getter(EvaluateRequest::evaluationTarget)).setter(EvaluateRequest.setter(Builder::evaluationTarget)).constructor(EvaluationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATOR_ID_FIELD, EVALUATION_INPUT_FIELD, EVALUATION_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateRequest.memberNameToFieldInitializer();
    private final String evaluatorId;
    private final EvaluationInput evaluationInput;
    private final EvaluationTarget evaluationTarget;

    private EvaluateRequest(BuilderImpl builder) {
        super(builder);
        this.evaluatorId = builder.evaluatorId;
        this.evaluationInput = builder.evaluationInput;
        this.evaluationTarget = builder.evaluationTarget;
    }

    public final String evaluatorId() {
        return this.evaluatorId;
    }

    public final EvaluationInput evaluationInput() {
        return this.evaluationInput;
    }

    public final EvaluationTarget evaluationTarget() {
        return this.evaluationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateRequest)) {
            return false;
        }
        EvaluateRequest other = (EvaluateRequest)((Object)obj);
        return Objects.equals(this.evaluatorId(), other.evaluatorId()) && Objects.equals(this.evaluationInput(), other.evaluationInput()) && Objects.equals(this.evaluationTarget(), other.evaluationTarget());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateRequest").add("EvaluatorId", (Object)this.evaluatorId()).add("EvaluationInput", (Object)this.evaluationInput()).add("EvaluationTarget", (Object)this.evaluationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluatorId": {
                return Optional.ofNullable(clazz.cast(this.evaluatorId()));
            }
            case "evaluationInput": {
                return Optional.ofNullable(clazz.cast(this.evaluationInput()));
            }
            case "evaluationTarget": {
                return Optional.ofNullable(clazz.cast(this.evaluationTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluatorId", EVALUATOR_ID_FIELD);
        map.put("evaluationInput", EVALUATION_INPUT_FIELD);
        map.put("evaluationTarget", EVALUATION_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateRequest, T> g) {
        return obj -> g.apply((EvaluateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String evaluatorId;
        private EvaluationInput evaluationInput;
        private EvaluationTarget evaluationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateRequest model) {
            super(model);
            this.evaluatorId(model.evaluatorId);
            this.evaluationInput(model.evaluationInput);
            this.evaluationTarget(model.evaluationTarget);
        }

        public final String getEvaluatorId() {
            return this.evaluatorId;
        }

        public final void setEvaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
        }

        @Override
        public final Builder evaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
            return this;
        }

        public final EvaluationInput.Builder getEvaluationInput() {
            return this.evaluationInput != null ? this.evaluationInput.toBuilder() : null;
        }

        public final void setEvaluationInput(EvaluationInput.BuilderImpl evaluationInput) {
            this.evaluationInput = evaluationInput != null ? evaluationInput.build() : null;
        }

        @Override
        public final Builder evaluationInput(EvaluationInput evaluationInput) {
            this.evaluationInput = evaluationInput;
            return this;
        }

        public final EvaluationTarget.Builder getEvaluationTarget() {
            return this.evaluationTarget != null ? this.evaluationTarget.toBuilder() : null;
        }

        public final void setEvaluationTarget(EvaluationTarget.BuilderImpl evaluationTarget) {
            this.evaluationTarget = evaluationTarget != null ? evaluationTarget.build() : null;
        }

        @Override
        public final Builder evaluationTarget(EvaluationTarget evaluationTarget) {
            this.evaluationTarget = evaluationTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateRequest build() {
            return new EvaluateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateRequest> {
        public Builder evaluatorId(String var1);

        public Builder evaluationInput(EvaluationInput var1);

        default public Builder evaluationInput(Consumer<EvaluationInput.Builder> evaluationInput) {
            return this.evaluationInput((EvaluationInput)((EvaluationInput.Builder)EvaluationInput.builder().applyMutation(evaluationInput)).build());
        }

        public Builder evaluationTarget(EvaluationTarget var1);

        default public Builder evaluationTarget(Consumer<EvaluationTarget.Builder> evaluationTarget) {
            return this.evaluationTarget((EvaluationTarget)((EvaluationTarget.Builder)EvaluationTarget.builder().applyMutation(evaluationTarget)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

