/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpanContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpanContext> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(SpanContext.getter(SpanContext::sessionId)).setter(SpanContext.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(SpanContext.getter(SpanContext::traceId)).setter(SpanContext.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final SdkField<String> SPAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spanId").getter(SpanContext.getter(SpanContext::spanId)).setter(SpanContext.setter(Builder::spanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, TRACE_ID_FIELD, SPAN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpanContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final String traceId;
    private final String spanId;

    private SpanContext(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.traceId = builder.traceId;
        this.spanId = builder.spanId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String spanId() {
        return this.spanId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spanId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanContext)) {
            return false;
        }
        SpanContext other = (SpanContext)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.spanId(), other.spanId());
    }

    public final String toString() {
        return ToString.builder((String)"SpanContext").add("SessionId", (Object)this.sessionId()).add("TraceId", (Object)this.traceId()).add("SpanId", (Object)this.spanId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "spanId": {
                return Optional.ofNullable(clazz.cast(this.spanId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("traceId", TRACE_ID_FIELD);
        map.put("spanId", SPAN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanContext, T> g) {
        return obj -> g.apply((SpanContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private String traceId;
        private String spanId;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanContext model) {
            this.sessionId(model.sessionId);
            this.traceId(model.traceId);
            this.spanId(model.spanId);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getSpanId() {
            return this.spanId;
        }

        public final void setSpanId(String spanId) {
            this.spanId = spanId;
        }

        @Override
        public final Builder spanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public SpanContext build() {
            return new SpanContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpanContext> {
        public Builder sessionId(String var1);

        public Builder traceId(String var1);

        public Builder spanId(String var1);
    }
}

