/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ToolArguments;
import software.amazon.awssdk.services.bedrockagentcore.model.ToolName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeCodeInterpreterRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, InvokeCodeInterpreterRequest> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterIdentifier").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::codeInterpreterIdentifier)).setter(InvokeCodeInterpreterRequest.setter(Builder::codeInterpreterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("codeInterpreterIdentifier").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::sessionId)).setter(InvokeCodeInterpreterRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-code-interpreter-session-id").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::traceId)).setter(InvokeCodeInterpreterRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()}).build();
    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceParent").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::traceParent)).setter(InvokeCodeInterpreterRequest.setter(Builder::traceParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::nameAsString)).setter(InvokeCodeInterpreterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ToolArguments> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arguments").getter(InvokeCodeInterpreterRequest.getter(InvokeCodeInterpreterRequest::arguments)).setter(InvokeCodeInterpreterRequest.setter(Builder::arguments)).constructor(ToolArguments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arguments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, TRACE_ID_FIELD, TRACE_PARENT_FIELD, NAME_FIELD, ARGUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeCodeInterpreterRequest.memberNameToFieldInitializer();
    private final String codeInterpreterIdentifier;
    private final String sessionId;
    private final String traceId;
    private final String traceParent;
    private final String name;
    private final ToolArguments arguments;

    private InvokeCodeInterpreterRequest(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.name = builder.name;
        this.arguments = builder.arguments;
    }

    public final String codeInterpreterIdentifier() {
        return this.codeInterpreterIdentifier;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String traceParent() {
        return this.traceParent;
    }

    public final ToolName name() {
        return ToolName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final ToolArguments arguments() {
        return this.arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeCodeInterpreterRequest)) {
            return false;
        }
        InvokeCodeInterpreterRequest other = (InvokeCodeInterpreterRequest)((Object)obj);
        return Objects.equals(this.codeInterpreterIdentifier(), other.codeInterpreterIdentifier()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.traceParent(), other.traceParent()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.arguments(), other.arguments());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeCodeInterpreterRequest").add("CodeInterpreterIdentifier", (Object)this.codeInterpreterIdentifier()).add("SessionId", (Object)this.sessionId()).add("TraceId", (Object)this.traceId()).add("TraceParent", (Object)this.traceParent()).add("Name", (Object)this.nameAsString()).add("Arguments", (Object)this.arguments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeInterpreterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterIdentifier()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "traceParent": {
                return Optional.ofNullable(clazz.cast(this.traceParent()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("x-amzn-code-interpreter-session-id", SESSION_ID_FIELD);
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arguments", ARGUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeCodeInterpreterRequest, T> g) {
        return obj -> g.apply((InvokeCodeInterpreterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String codeInterpreterIdentifier;
        private String sessionId;
        private String traceId;
        private String traceParent;
        private String name;
        private ToolArguments arguments;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeCodeInterpreterRequest model) {
            super(model);
            this.codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            this.sessionId(model.sessionId);
            this.traceId(model.traceId);
            this.traceParent(model.traceParent);
            this.name(model.name);
            this.arguments(model.arguments);
        }

        public final String getCodeInterpreterIdentifier() {
            return this.codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return this.traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ToolName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final ToolArguments.Builder getArguments() {
            return this.arguments != null ? this.arguments.toBuilder() : null;
        }

        public final void setArguments(ToolArguments.BuilderImpl arguments) {
            this.arguments = arguments != null ? arguments.build() : null;
        }

        @Override
        public final Builder arguments(ToolArguments arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeCodeInterpreterRequest build() {
            return new InvokeCodeInterpreterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeCodeInterpreterRequest> {
        public Builder codeInterpreterIdentifier(String var1);

        public Builder sessionId(String var1);

        public Builder traceId(String var1);

        public Builder traceParent(String var1);

        public Builder name(String var1);

        public Builder name(ToolName var1);

        public Builder arguments(ToolArguments var1);

        default public Builder arguments(Consumer<ToolArguments.Builder> arguments) {
            return this.arguments((ToolArguments)((ToolArguments.Builder)ToolArguments.builder().applyMutation(arguments)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

