/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJobMessages;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtractionJobMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtractionJobMetadata> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobID").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::jobID)).setter(ExtractionJobMetadata.setter(Builder::jobID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()}).build();
    private static final SdkField<ExtractionJobMessages> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messages").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::messages)).setter(ExtractionJobMetadata.setter(Builder::messages)).constructor(ExtractionJobMessages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::statusAsString)).setter(ExtractionJobMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::failureReason)).setter(ExtractionJobMetadata.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategyId").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::strategyId)).setter(ExtractionJobMetadata.setter(Builder::strategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::sessionId)).setter(ExtractionJobMetadata.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> ACTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actorId").getter(ExtractionJobMetadata.getter(ExtractionJobMetadata::actorId)).setter(ExtractionJobMetadata.setter(Builder::actorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, MESSAGES_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, STRATEGY_ID_FIELD, SESSION_ID_FIELD, ACTOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExtractionJobMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobID;
    private final ExtractionJobMessages messages;
    private final String status;
    private final String failureReason;
    private final String strategyId;
    private final String sessionId;
    private final String actorId;

    private ExtractionJobMetadata(BuilderImpl builder) {
        this.jobID = builder.jobID;
        this.messages = builder.messages;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.strategyId = builder.strategyId;
        this.sessionId = builder.sessionId;
        this.actorId = builder.actorId;
    }

    public final String jobID() {
        return this.jobID;
    }

    public final ExtractionJobMessages messages() {
        return this.messages;
    }

    public final ExtractionJobStatus status() {
        return ExtractionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String strategyId() {
        return this.strategyId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String actorId() {
        return this.actorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobID());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtractionJobMetadata)) {
            return false;
        }
        ExtractionJobMetadata other = (ExtractionJobMetadata)obj;
        return Objects.equals(this.jobID(), other.jobID()) && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.strategyId(), other.strategyId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.actorId(), other.actorId());
    }

    public final String toString() {
        return ToString.builder((String)"ExtractionJobMetadata").add("JobID", (Object)this.jobID()).add("Messages", (Object)this.messages()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("StrategyId", (Object)this.strategyId()).add("SessionId", (Object)this.sessionId()).add("ActorId", (Object)this.actorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobID": {
                return Optional.ofNullable(clazz.cast(this.jobID()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "strategyId": {
                return Optional.ofNullable(clazz.cast(this.strategyId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "actorId": {
                return Optional.ofNullable(clazz.cast(this.actorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobID", JOB_ID_FIELD);
        map.put("messages", MESSAGES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("strategyId", STRATEGY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("actorId", ACTOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtractionJobMetadata, T> g) {
        return obj -> g.apply((ExtractionJobMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobID;
        private ExtractionJobMessages messages;
        private String status;
        private String failureReason;
        private String strategyId;
        private String sessionId;
        private String actorId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtractionJobMetadata model) {
            this.jobID(model.jobID);
            this.messages(model.messages);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.strategyId(model.strategyId);
            this.sessionId(model.sessionId);
            this.actorId(model.actorId);
        }

        public final String getJobID() {
            return this.jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final ExtractionJobMessages.Builder getMessages() {
            return this.messages != null ? this.messages.toBuilder() : null;
        }

        public final void setMessages(ExtractionJobMessages.BuilderImpl messages) {
            this.messages = messages != null ? messages.build() : null;
        }

        @Override
        public final Builder messages(ExtractionJobMessages messages) {
            this.messages = messages;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExtractionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getStrategyId() {
            return this.strategyId;
        }

        public final void setStrategyId(String strategyId) {
            this.strategyId = strategyId;
        }

        @Override
        public final Builder strategyId(String strategyId) {
            this.strategyId = strategyId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActorId() {
            return this.actorId;
        }

        public final void setActorId(String actorId) {
            this.actorId = actorId;
        }

        @Override
        public final Builder actorId(String actorId) {
            this.actorId = actorId;
            return this;
        }

        public ExtractionJobMetadata build() {
            return new ExtractionJobMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtractionJobMetadata> {
        public Builder jobID(String var1);

        public Builder messages(ExtractionJobMessages var1);

        default public Builder messages(Consumer<ExtractionJobMessages.Builder> messages) {
            return this.messages((ExtractionJobMessages)((ExtractionJobMessages.Builder)ExtractionJobMessages.builder().applyMutation(messages)).build());
        }

        public Builder status(String var1);

        public Builder status(ExtractionJobStatus var1);

        public Builder failureReason(String var1);

        public Builder strategyId(String var1);

        public Builder sessionId(String var1);

        public Builder actorId(String var1);
    }
}

