/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreAsyncClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJobMetadata;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryExtractionJobsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryExtractionJobsResponse;

public class ListMemoryExtractionJobsPublisher
implements SdkPublisher<ListMemoryExtractionJobsResponse> {
    private final BedrockAgentCoreAsyncClient client;
    private final ListMemoryExtractionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMemoryExtractionJobsPublisher(BedrockAgentCoreAsyncClient client, ListMemoryExtractionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMemoryExtractionJobsPublisher(BedrockAgentCoreAsyncClient client, ListMemoryExtractionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMemoryExtractionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMemoryExtractionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExtractionJobMetadata> jobs() {
        Function<ListMemoryExtractionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMemoryExtractionJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMemoryExtractionJobsResponseFetcher
    implements AsyncPageFetcher<ListMemoryExtractionJobsResponse> {
        private ListMemoryExtractionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoryExtractionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMemoryExtractionJobsResponse> nextPage(ListMemoryExtractionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMemoryExtractionJobsPublisher.this.client.listMemoryExtractionJobs(ListMemoryExtractionJobsPublisher.this.firstRequest);
            }
            return ListMemoryExtractionJobsPublisher.this.client.listMemoryExtractionJobs((ListMemoryExtractionJobsRequest)((Object)ListMemoryExtractionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

