/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.SpanIdsCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.TraceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationTarget> {
    private static final SdkField<List<String>> SPAN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("spanIds").getter(EvaluationTarget.getter(EvaluationTarget::spanIds)).setter(EvaluationTarget.setter(Builder::spanIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spanIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("traceIds").getter(EvaluationTarget.getter(EvaluationTarget::traceIds)).setter(EvaluationTarget.setter(Builder::traceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPAN_IDS_FIELD, TRACE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> spanIds;
    private final List<String> traceIds;
    private final Type type;

    private EvaluationTarget(BuilderImpl builder) {
        this.spanIds = builder.spanIds;
        this.traceIds = builder.traceIds;
        this.type = builder.type;
    }

    public final boolean hasSpanIds() {
        return this.spanIds != null && !(this.spanIds instanceof SdkAutoConstructList);
    }

    public final List<String> spanIds() {
        return this.spanIds;
    }

    public final boolean hasTraceIds() {
        return this.traceIds != null && !(this.traceIds instanceof SdkAutoConstructList);
    }

    public final List<String> traceIds() {
        return this.traceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpanIds() ? this.spanIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraceIds() ? this.traceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationTarget)) {
            return false;
        }
        EvaluationTarget other = (EvaluationTarget)obj;
        return this.hasSpanIds() == other.hasSpanIds() && Objects.equals(this.spanIds(), other.spanIds()) && this.hasTraceIds() == other.hasTraceIds() && Objects.equals(this.traceIds(), other.traceIds());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationTarget").add("SpanIds", this.hasSpanIds() ? this.spanIds() : null).add("TraceIds", this.hasTraceIds() ? this.traceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spanIds": {
                return Optional.ofNullable(clazz.cast(this.spanIds()));
            }
            case "traceIds": {
                return Optional.ofNullable(clazz.cast(this.traceIds()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationTarget fromSpanIds(List<String> spanIds) {
        return (EvaluationTarget)EvaluationTarget.builder().spanIds(spanIds).build();
    }

    public static EvaluationTarget fromTraceIds(List<String> traceIds) {
        return (EvaluationTarget)EvaluationTarget.builder().traceIds(traceIds).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("spanIds", SPAN_IDS_FIELD);
        map.put("traceIds", TRACE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationTarget, T> g) {
        return obj -> g.apply((EvaluationTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SPAN_IDS,
        TRACE_IDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> spanIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> traceIds = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationTarget model) {
            this.spanIds(model.spanIds);
            this.traceIds(model.traceIds);
        }

        public final Collection<String> getSpanIds() {
            if (this.spanIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spanIds;
        }

        public final void setSpanIds(Collection<String> spanIds) {
            List<String> oldValue = this.spanIds;
            this.spanIds = SpanIdsCopier.copy(spanIds);
            this.handleUnionValueChange(Type.SPAN_IDS, oldValue, this.spanIds);
        }

        @Override
        public final Builder spanIds(Collection<String> spanIds) {
            List<String> oldValue = this.spanIds;
            this.spanIds = SpanIdsCopier.copy(spanIds);
            this.handleUnionValueChange(Type.SPAN_IDS, oldValue, this.spanIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spanIds(String ... spanIds) {
            this.spanIds(Arrays.asList(spanIds));
            return this;
        }

        public final Collection<String> getTraceIds() {
            if (this.traceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.traceIds;
        }

        public final void setTraceIds(Collection<String> traceIds) {
            List<String> oldValue = this.traceIds;
            this.traceIds = TraceIdsCopier.copy(traceIds);
            this.handleUnionValueChange(Type.TRACE_IDS, oldValue, this.traceIds);
        }

        @Override
        public final Builder traceIds(Collection<String> traceIds) {
            List<String> oldValue = this.traceIds;
            this.traceIds = TraceIdsCopier.copy(traceIds);
            this.handleUnionValueChange(Type.TRACE_IDS, oldValue, this.traceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceIds(String ... traceIds) {
            this.traceIds(Arrays.asList(traceIds));
            return this;
        }

        public EvaluationTarget build() {
            return new EvaluationTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationTarget> {
        public Builder spanIds(Collection<String> var1);

        public Builder spanIds(String ... var1);

        public Builder traceIds(Collection<String> var1);

        public Builder traceIds(String ... var1);
    }
}

