/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.MessageMetadata;
import software.amazon.awssdk.services.bedrockagentcore.model.MessagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtractionJobMessages
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtractionJobMessages> {
    private static final SdkField<List<MessageMetadata>> MESSAGES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messagesList").getter(ExtractionJobMessages.getter(ExtractionJobMessages::messagesList)).setter(ExtractionJobMessages.setter(Builder::messagesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messagesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExtractionJobMessages.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MessageMetadata> messagesList;
    private final Type type;

    private ExtractionJobMessages(BuilderImpl builder) {
        this.messagesList = builder.messagesList;
        this.type = builder.type;
    }

    public final boolean hasMessagesList() {
        return this.messagesList != null && !(this.messagesList instanceof SdkAutoConstructList);
    }

    public final List<MessageMetadata> messagesList() {
        return this.messagesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessagesList() ? this.messagesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtractionJobMessages)) {
            return false;
        }
        ExtractionJobMessages other = (ExtractionJobMessages)obj;
        return this.hasMessagesList() == other.hasMessagesList() && Objects.equals(this.messagesList(), other.messagesList());
    }

    public final String toString() {
        return ToString.builder((String)"ExtractionJobMessages").add("MessagesList", this.hasMessagesList() ? this.messagesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messagesList": {
                return Optional.ofNullable(clazz.cast(this.messagesList()));
            }
        }
        return Optional.empty();
    }

    public static ExtractionJobMessages fromMessagesList(List<MessageMetadata> messagesList) {
        return (ExtractionJobMessages)ExtractionJobMessages.builder().messagesList(messagesList).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<MessageMetadata>>> map = new HashMap<String, SdkField<List<MessageMetadata>>>();
        map.put("messagesList", MESSAGES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtractionJobMessages, T> g) {
        return obj -> g.apply((ExtractionJobMessages)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MESSAGES_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<MessageMetadata> messagesList = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExtractionJobMessages model) {
            this.messagesList(model.messagesList);
        }

        public final List<MessageMetadata.Builder> getMessagesList() {
            List<MessageMetadata.Builder> result = MessagesListCopier.copyToBuilder(this.messagesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessagesList(Collection<MessageMetadata.BuilderImpl> messagesList) {
            List<MessageMetadata> oldValue = this.messagesList;
            this.messagesList = MessagesListCopier.copyFromBuilder(messagesList);
            this.handleUnionValueChange(Type.MESSAGES_LIST, oldValue, this.messagesList);
        }

        @Override
        public final Builder messagesList(Collection<MessageMetadata> messagesList) {
            List<MessageMetadata> oldValue = this.messagesList;
            this.messagesList = MessagesListCopier.copy(messagesList);
            this.handleUnionValueChange(Type.MESSAGES_LIST, oldValue, this.messagesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messagesList(MessageMetadata ... messagesList) {
            this.messagesList(Arrays.asList(messagesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messagesList(Consumer<MessageMetadata.Builder> ... messagesList) {
            this.messagesList(Stream.of(messagesList).map(c -> (MessageMetadata)((MessageMetadata.Builder)MessageMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExtractionJobMessages build() {
            return new ExtractionJobMessages(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtractionJobMessages> {
        public Builder messagesList(Collection<MessageMetadata> var1);

        public Builder messagesList(MessageMetadata ... var1);

        public Builder messagesList(Consumer<MessageMetadata.Builder> ... var1);
    }
}

