/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.SessionSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.SessionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSessionsResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, ListSessionsResponse> {
    private static final SdkField<List<SessionSummary>> SESSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionSummaries").getter(ListSessionsResponse.getter(ListSessionsResponse::sessionSummaries)).setter(ListSessionsResponse.setter(Builder::sessionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSessionsResponse.getter(ListSessionsResponse::nextToken)).setter(ListSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSessionsResponse.memberNameToFieldInitializer();
    private final List<SessionSummary> sessionSummaries;
    private final String nextToken;

    private ListSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionSummaries = builder.sessionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSessionSummaries() {
        return this.sessionSummaries != null && !(this.sessionSummaries instanceof SdkAutoConstructList);
    }

    public final List<SessionSummary> sessionSummaries() {
        return this.sessionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionSummaries() ? this.sessionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsResponse)) {
            return false;
        }
        ListSessionsResponse other = (ListSessionsResponse)((Object)obj);
        return this.hasSessionSummaries() == other.hasSessionSummaries() && Objects.equals(this.sessionSummaries(), other.sessionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSessionsResponse").add("SessionSummaries", this.hasSessionSummaries() ? this.sessionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionSummaries": {
                return Optional.ofNullable(clazz.cast(this.sessionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionSummaries", SESSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsResponse, T> g) {
        return obj -> g.apply((ListSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private List<SessionSummary> sessionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsResponse model) {
            super(model);
            this.sessionSummaries(model.sessionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SessionSummary.Builder> getSessionSummaries() {
            List<SessionSummary.Builder> result = SessionSummaryListCopier.copyToBuilder(this.sessionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionSummaries(Collection<SessionSummary.BuilderImpl> sessionSummaries) {
            this.sessionSummaries = SessionSummaryListCopier.copyFromBuilder(sessionSummaries);
        }

        @Override
        public final Builder sessionSummaries(Collection<SessionSummary> sessionSummaries) {
            this.sessionSummaries = SessionSummaryListCopier.copy(sessionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionSummaries(SessionSummary ... sessionSummaries) {
            this.sessionSummaries(Arrays.asList(sessionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionSummaries(Consumer<SessionSummary.Builder> ... sessionSummaries) {
            this.sessionSummaries(Stream.of(sessionSummaries).map(c -> (SessionSummary)((SessionSummary.Builder)SessionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSessionsResponse build() {
            return new ListSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSessionsResponse> {
        public Builder sessionSummaries(Collection<SessionSummary> var1);

        public Builder sessionSummaries(SessionSummary ... var1);

        public Builder sessionSummaries(Consumer<SessionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

