/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.ExtractionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtractionJobFilterInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtractionJobFilterInput> {
    private static final SdkField<String> STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategyId").getter(ExtractionJobFilterInput.getter(ExtractionJobFilterInput::strategyId)).setter(ExtractionJobFilterInput.setter(Builder::strategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ExtractionJobFilterInput.getter(ExtractionJobFilterInput::sessionId)).setter(ExtractionJobFilterInput.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> ACTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actorId").getter(ExtractionJobFilterInput.getter(ExtractionJobFilterInput::actorId)).setter(ExtractionJobFilterInput.setter(Builder::actorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ExtractionJobFilterInput.getter(ExtractionJobFilterInput::statusAsString)).setter(ExtractionJobFilterInput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_ID_FIELD, SESSION_ID_FIELD, ACTOR_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExtractionJobFilterInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String strategyId;
    private final String sessionId;
    private final String actorId;
    private final String status;

    private ExtractionJobFilterInput(BuilderImpl builder) {
        this.strategyId = builder.strategyId;
        this.sessionId = builder.sessionId;
        this.actorId = builder.actorId;
        this.status = builder.status;
    }

    public final String strategyId() {
        return this.strategyId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String actorId() {
        return this.actorId;
    }

    public final ExtractionJobStatus status() {
        return ExtractionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtractionJobFilterInput)) {
            return false;
        }
        ExtractionJobFilterInput other = (ExtractionJobFilterInput)obj;
        return Objects.equals(this.strategyId(), other.strategyId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.actorId(), other.actorId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExtractionJobFilterInput").add("StrategyId", (Object)this.strategyId()).add("SessionId", (Object)this.sessionId()).add("ActorId", (Object)this.actorId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "strategyId": {
                return Optional.ofNullable(clazz.cast(this.strategyId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "actorId": {
                return Optional.ofNullable(clazz.cast(this.actorId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("strategyId", STRATEGY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("actorId", ACTOR_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtractionJobFilterInput, T> g) {
        return obj -> g.apply((ExtractionJobFilterInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategyId;
        private String sessionId;
        private String actorId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtractionJobFilterInput model) {
            this.strategyId(model.strategyId);
            this.sessionId(model.sessionId);
            this.actorId(model.actorId);
            this.status(model.status);
        }

        public final String getStrategyId() {
            return this.strategyId;
        }

        public final void setStrategyId(String strategyId) {
            this.strategyId = strategyId;
        }

        @Override
        public final Builder strategyId(String strategyId) {
            this.strategyId = strategyId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getActorId() {
            return this.actorId;
        }

        public final void setActorId(String actorId) {
            this.actorId = actorId;
        }

        @Override
        public final Builder actorId(String actorId) {
            this.actorId = actorId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExtractionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ExtractionJobFilterInput build() {
            return new ExtractionJobFilterInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtractionJobFilterInput> {
        public Builder strategyId(String var1);

        public Builder sessionId(String var1);

        public Builder actorId(String var1);

        public Builder status(String var1);

        public Builder status(ExtractionJobStatus var1);
    }
}

