/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserIdentifier> {
    private static final SdkField<String> USER_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userToken").getter(UserIdentifier.getter(UserIdentifier::userToken)).setter(UserIdentifier.setter(Builder::userToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userToken").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UserIdentifier.getter(UserIdentifier::userId)).setter(UserIdentifier.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_TOKEN_FIELD, USER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userToken;
    private final String userId;
    private final Type type;

    private UserIdentifier(BuilderImpl builder) {
        this.userToken = builder.userToken;
        this.userId = builder.userId;
        this.type = builder.type;
    }

    public final String userToken() {
        return this.userToken;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentifier)) {
            return false;
        }
        UserIdentifier other = (UserIdentifier)obj;
        return Objects.equals(this.userToken(), other.userToken()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"UserIdentifier").add("UserToken", (Object)(this.userToken() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userToken": {
                return Optional.ofNullable(clazz.cast(this.userToken()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public static UserIdentifier fromUserToken(String userToken) {
        return (UserIdentifier)UserIdentifier.builder().userToken(userToken).build();
    }

    public static UserIdentifier fromUserId(String userId) {
        return (UserIdentifier)UserIdentifier.builder().userId(userId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("userToken", USER_TOKEN_FIELD);
        map.put("userId", USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserIdentifier, T> g) {
        return obj -> g.apply((UserIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        USER_TOKEN,
        USER_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String userToken;
        private String userId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentifier model) {
            this.userToken(model.userToken);
            this.userId(model.userId);
        }

        public final String getUserToken() {
            return this.userToken;
        }

        public final void setUserToken(String userToken) {
            String oldValue = this.userToken;
            this.userToken = userToken;
            this.handleUnionValueChange(Type.USER_TOKEN, oldValue, this.userToken);
        }

        @Override
        public final Builder userToken(String userToken) {
            String oldValue = this.userToken;
            this.userToken = userToken;
            this.handleUnionValueChange(Type.USER_TOKEN, oldValue, this.userToken);
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            String oldValue = this.userId;
            this.userId = userId;
            this.handleUnionValueChange(Type.USER_ID, oldValue, this.userId);
        }

        @Override
        public final Builder userId(String userId) {
            String oldValue = this.userId;
            this.userId = userId;
            this.handleUnionValueChange(Type.USER_ID, oldValue, this.userId);
            return this;
        }

        public UserIdentifier build() {
            return new UserIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserIdentifier> {
        public Builder userToken(String var1);

        public Builder userId(String var1);
    }
}

