/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.ContentBlockType;
import software.amazon.awssdk.services.bedrockagentcore.model.ResourceContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBlock> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ContentBlock.getter(ContentBlock::typeAsString)).setter(ContentBlock.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ContentBlock.getter(ContentBlock::text)).setter(ContentBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("data").getter(ContentBlock.getter(ContentBlock::data)).setter(ContentBlock.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mimeType").getter(ContentBlock.getter(ContentBlock::mimeType)).setter(ContentBlock.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(ContentBlock.getter(ContentBlock::uri)).setter(ContentBlock.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContentBlock.getter(ContentBlock::name)).setter(ContentBlock.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ContentBlock.getter(ContentBlock::description)).setter(ContentBlock.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(ContentBlock.getter(ContentBlock::size)).setter(ContentBlock.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<ResourceContent> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(ContentBlock.getter(ContentBlock::resource)).setter(ContentBlock.setter(Builder::resource)).constructor(ResourceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TEXT_FIELD, DATA_FIELD, MIME_TYPE_FIELD, URI_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SIZE_FIELD, RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String text;
    private final SdkBytes data;
    private final String mimeType;
    private final String uri;
    private final String name;
    private final String description;
    private final Long size;
    private final ResourceContent resource;

    private ContentBlock(BuilderImpl builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.data = builder.data;
        this.mimeType = builder.mimeType;
        this.uri = builder.uri;
        this.name = builder.name;
        this.description = builder.description;
        this.size = builder.size;
        this.resource = builder.resource;
    }

    public final ContentBlockType type() {
        return ContentBlockType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String text() {
        return this.text;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public final String uri() {
        return this.uri;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Long size() {
        return this.size;
    }

    public final ResourceContent resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlock)) {
            return false;
        }
        ContentBlock other = (ContentBlock)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.mimeType(), other.mimeType()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBlock").add("Type", (Object)this.typeAsString()).add("Text", (Object)this.text()).add("Data", (Object)this.data()).add("MimeType", (Object)this.mimeType()).add("Uri", (Object)this.uri()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Size", (Object)this.size()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "mimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("data", DATA_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("uri", URI_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlock, T> g) {
        return obj -> g.apply((ContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String text;
        private SdkBytes data;
        private String mimeType;
        private String uri;
        private String name;
        private String description;
        private Long size;
        private ResourceContent resource;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlock model) {
            this.type(model.type);
            this.text(model.text);
            this.data(model.data);
            this.mimeType(model.mimeType);
            this.uri(model.uri);
            this.name(model.name);
            this.description(model.description);
            this.size(model.size);
            this.resource(model.resource);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContentBlockType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final ResourceContent.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(ResourceContent.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(ResourceContent resource) {
            this.resource = resource;
            return this;
        }

        public ContentBlock build() {
            return new ContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBlock> {
        public Builder type(String var1);

        public Builder type(ContentBlockType var1);

        public Builder text(String var1);

        public Builder data(SdkBytes var1);

        public Builder mimeType(String var1);

        public Builder uri(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder size(Long var1);

        public Builder resource(ResourceContent var1);

        default public Builder resource(Consumer<ResourceContent.Builder> resource) {
            return this.resource((ResourceContent)((ResourceContent.Builder)ResourceContent.builder().applyMutation(resource)).build());
        }
    }
}

