/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.SpansCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationInput> {
    private static final SdkField<List<Document>> SESSION_SPANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionSpans").getter(EvaluationInput.getter(EvaluationInput::sessionSpans)).setter(EvaluationInput.setter(Builder::sessionSpans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionSpans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_SPANS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Document> sessionSpans;
    private final Type type;

    private EvaluationInput(BuilderImpl builder) {
        this.sessionSpans = builder.sessionSpans;
        this.type = builder.type;
    }

    public final boolean hasSessionSpans() {
        return this.sessionSpans != null && !(this.sessionSpans instanceof SdkAutoConstructList);
    }

    public final List<Document> sessionSpans() {
        return this.sessionSpans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionSpans() ? this.sessionSpans() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationInput)) {
            return false;
        }
        EvaluationInput other = (EvaluationInput)obj;
        return this.hasSessionSpans() == other.hasSessionSpans() && Objects.equals(this.sessionSpans(), other.sessionSpans());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationInput").add("SessionSpans", (Object)(this.sessionSpans() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionSpans": {
                return Optional.ofNullable(clazz.cast(this.sessionSpans()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationInput fromSessionSpans(List<Document> sessionSpans) {
        return (EvaluationInput)EvaluationInput.builder().sessionSpans(sessionSpans).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Document>>> map = new HashMap<String, SdkField<List<Document>>>();
        map.put("sessionSpans", SESSION_SPANS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationInput, T> g) {
        return obj -> g.apply((EvaluationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SESSION_SPANS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<Document> sessionSpans = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationInput model) {
            this.sessionSpans(model.sessionSpans);
        }

        public final Collection<Document> getSessionSpans() {
            if (this.sessionSpans instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sessionSpans;
        }

        public final void setSessionSpans(Collection<Document> sessionSpans) {
            List<Document> oldValue = this.sessionSpans;
            this.sessionSpans = SpansCopier.copy(sessionSpans);
            this.handleUnionValueChange(Type.SESSION_SPANS, oldValue, this.sessionSpans);
        }

        @Override
        public final Builder sessionSpans(Collection<Document> sessionSpans) {
            List<Document> oldValue = this.sessionSpans;
            this.sessionSpans = SpansCopier.copy(sessionSpans);
            this.handleUnionValueChange(Type.SESSION_SPANS, oldValue, this.sessionSpans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionSpans(Document ... sessionSpans) {
            this.sessionSpans(Arrays.asList(sessionSpans));
            return this;
        }

        public EvaluationInput build() {
            return new EvaluationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationInput> {
        public Builder sessionSpans(Collection<Document> var1);

        public Builder sessionSpans(Document ... var1);
    }
}

