/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordOutput;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordsOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateMemoryRecordsResponse
extends BedrockAgentCoreResponse
implements ToCopyableBuilder<Builder, BatchCreateMemoryRecordsResponse> {
    private static final SdkField<List<MemoryRecordOutput>> SUCCESSFUL_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulRecords").getter(BatchCreateMemoryRecordsResponse.getter(BatchCreateMemoryRecordsResponse::successfulRecords)).setter(BatchCreateMemoryRecordsResponse.setter(Builder::successfulRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryRecordOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MemoryRecordOutput>> FAILED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedRecords").getter(BatchCreateMemoryRecordsResponse.getter(BatchCreateMemoryRecordsResponse::failedRecords)).setter(BatchCreateMemoryRecordsResponse.setter(Builder::failedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryRecordOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_RECORDS_FIELD, FAILED_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateMemoryRecordsResponse.memberNameToFieldInitializer();
    private final List<MemoryRecordOutput> successfulRecords;
    private final List<MemoryRecordOutput> failedRecords;

    private BatchCreateMemoryRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulRecords = builder.successfulRecords;
        this.failedRecords = builder.failedRecords;
    }

    public final boolean hasSuccessfulRecords() {
        return this.successfulRecords != null && !(this.successfulRecords instanceof SdkAutoConstructList);
    }

    public final List<MemoryRecordOutput> successfulRecords() {
        return this.successfulRecords;
    }

    public final boolean hasFailedRecords() {
        return this.failedRecords != null && !(this.failedRecords instanceof SdkAutoConstructList);
    }

    public final List<MemoryRecordOutput> failedRecords() {
        return this.failedRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulRecords() ? this.successfulRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRecords() ? this.failedRecords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateMemoryRecordsResponse)) {
            return false;
        }
        BatchCreateMemoryRecordsResponse other = (BatchCreateMemoryRecordsResponse)((Object)obj);
        return this.hasSuccessfulRecords() == other.hasSuccessfulRecords() && Objects.equals(this.successfulRecords(), other.successfulRecords()) && this.hasFailedRecords() == other.hasFailedRecords() && Objects.equals(this.failedRecords(), other.failedRecords());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateMemoryRecordsResponse").add("SuccessfulRecords", this.hasSuccessfulRecords() ? this.successfulRecords() : null).add("FailedRecords", this.hasFailedRecords() ? this.failedRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulRecords": {
                return Optional.ofNullable(clazz.cast(this.successfulRecords()));
            }
            case "failedRecords": {
                return Optional.ofNullable(clazz.cast(this.failedRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<MemoryRecordOutput>>> map = new HashMap<String, SdkField<List<MemoryRecordOutput>>>();
        map.put("successfulRecords", SUCCESSFUL_RECORDS_FIELD);
        map.put("failedRecords", FAILED_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateMemoryRecordsResponse, T> g) {
        return obj -> g.apply((BatchCreateMemoryRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreResponse.BuilderImpl
    implements Builder {
        private List<MemoryRecordOutput> successfulRecords = DefaultSdkAutoConstructList.getInstance();
        private List<MemoryRecordOutput> failedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateMemoryRecordsResponse model) {
            super(model);
            this.successfulRecords(model.successfulRecords);
            this.failedRecords(model.failedRecords);
        }

        public final List<MemoryRecordOutput.Builder> getSuccessfulRecords() {
            List<MemoryRecordOutput.Builder> result = MemoryRecordsOutputListCopier.copyToBuilder(this.successfulRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulRecords(Collection<MemoryRecordOutput.BuilderImpl> successfulRecords) {
            this.successfulRecords = MemoryRecordsOutputListCopier.copyFromBuilder(successfulRecords);
        }

        @Override
        public final Builder successfulRecords(Collection<MemoryRecordOutput> successfulRecords) {
            this.successfulRecords = MemoryRecordsOutputListCopier.copy(successfulRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRecords(MemoryRecordOutput ... successfulRecords) {
            this.successfulRecords(Arrays.asList(successfulRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRecords(Consumer<MemoryRecordOutput.Builder> ... successfulRecords) {
            this.successfulRecords(Stream.of(successfulRecords).map(c -> (MemoryRecordOutput)((MemoryRecordOutput.Builder)MemoryRecordOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MemoryRecordOutput.Builder> getFailedRecords() {
            List<MemoryRecordOutput.Builder> result = MemoryRecordsOutputListCopier.copyToBuilder(this.failedRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRecords(Collection<MemoryRecordOutput.BuilderImpl> failedRecords) {
            this.failedRecords = MemoryRecordsOutputListCopier.copyFromBuilder(failedRecords);
        }

        @Override
        public final Builder failedRecords(Collection<MemoryRecordOutput> failedRecords) {
            this.failedRecords = MemoryRecordsOutputListCopier.copy(failedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(MemoryRecordOutput ... failedRecords) {
            this.failedRecords(Arrays.asList(failedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(Consumer<MemoryRecordOutput.Builder> ... failedRecords) {
            this.failedRecords(Stream.of(failedRecords).map(c -> (MemoryRecordOutput)((MemoryRecordOutput.Builder)MemoryRecordOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateMemoryRecordsResponse build() {
            return new BatchCreateMemoryRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateMemoryRecordsResponse> {
        public Builder successfulRecords(Collection<MemoryRecordOutput> var1);

        public Builder successfulRecords(MemoryRecordOutput ... var1);

        public Builder successfulRecords(Consumer<MemoryRecordOutput.Builder> ... var1);

        public Builder failedRecords(Collection<MemoryRecordOutput> var1);

        public Builder failedRecords(MemoryRecordOutput ... var1);

        public Builder failedRecords(Consumer<MemoryRecordOutput.Builder> ... var1);
    }
}

