/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageMetadata> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(MessageMetadata.getter(MessageMetadata::eventId)).setter(MessageMetadata.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<Integer> MESSAGE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("messageIndex").getter(MessageMetadata.getter(MessageMetadata::messageIndex)).setter(MessageMetadata.setter(Builder::messageIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, MESSAGE_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final Integer messageIndex;

    private MessageMetadata(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.messageIndex = builder.messageIndex;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final Integer messageIndex() {
        return this.messageIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata other = (MessageMetadata)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.messageIndex(), other.messageIndex());
    }

    public final String toString() {
        return ToString.builder((String)"MessageMetadata").add("EventId", (Object)this.eventId()).add("MessageIndex", (Object)this.messageIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "messageIndex": {
                return Optional.ofNullable(clazz.cast(this.messageIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventId", EVENT_ID_FIELD);
        map.put("messageIndex", MESSAGE_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageMetadata, T> g) {
        return obj -> g.apply((MessageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private Integer messageIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageMetadata model) {
            this.eventId(model.eventId);
            this.messageIndex(model.messageIndex);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Integer getMessageIndex() {
            return this.messageIndex;
        }

        public final void setMessageIndex(Integer messageIndex) {
            this.messageIndex = messageIndex;
        }

        @Override
        public final Builder messageIndex(Integer messageIndex) {
            this.messageIndex = messageIndex;
            return this;
        }

        public MessageMetadata build() {
            return new MessageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageMetadata> {
        public Builder eventId(String var1);

        public Builder messageIndex(Integer var1);
    }
}

