/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreAsyncClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary;

public class ListMemoryRecordsPublisher
implements SdkPublisher<ListMemoryRecordsResponse> {
    private final BedrockAgentCoreAsyncClient client;
    private final ListMemoryRecordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMemoryRecordsPublisher(BedrockAgentCoreAsyncClient client, ListMemoryRecordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMemoryRecordsPublisher(BedrockAgentCoreAsyncClient client, ListMemoryRecordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMemoryRecordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMemoryRecordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemoryRecordSummary> memoryRecordSummaries() {
        Function<ListMemoryRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memoryRecordSummaries() != null) {
                return response.memoryRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMemoryRecordsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMemoryRecordsResponseFetcher
    implements AsyncPageFetcher<ListMemoryRecordsResponse> {
        private ListMemoryRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoryRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMemoryRecordsResponse> nextPage(ListMemoryRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListMemoryRecordsPublisher.this.client.listMemoryRecords(ListMemoryRecordsPublisher.this.firstRequest);
            }
            return ListMemoryRecordsPublisher.this.client.listMemoryRecords((ListMemoryRecordsRequest)((Object)ListMemoryRecordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

