/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryContent;
import software.amazon.awssdk.services.bedrockagentcore.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryRecordCreateInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryRecordCreateInput> {
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestIdentifier").getter(MemoryRecordCreateInput.getter(MemoryRecordCreateInput::requestIdentifier)).setter(MemoryRecordCreateInput.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestIdentifier").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(MemoryRecordCreateInput.getter(MemoryRecordCreateInput::namespaces)).setter(MemoryRecordCreateInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MemoryContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(MemoryRecordCreateInput.getter(MemoryRecordCreateInput::content)).setter(MemoryRecordCreateInput.setter(Builder::content)).constructor(MemoryContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(MemoryRecordCreateInput.getter(MemoryRecordCreateInput::timestamp)).setter(MemoryRecordCreateInput.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(MemoryRecordCreateInput.getter(MemoryRecordCreateInput::memoryStrategyId)).setter(MemoryRecordCreateInput.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_IDENTIFIER_FIELD, NAMESPACES_FIELD, CONTENT_FIELD, TIMESTAMP_FIELD, MEMORY_STRATEGY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemoryRecordCreateInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String requestIdentifier;
    private final List<String> namespaces;
    private final MemoryContent content;
    private final Instant timestamp;
    private final String memoryStrategyId;

    private MemoryRecordCreateInput(BuilderImpl builder) {
        this.requestIdentifier = builder.requestIdentifier;
        this.namespaces = builder.namespaces;
        this.content = builder.content;
        this.timestamp = builder.timestamp;
        this.memoryStrategyId = builder.memoryStrategyId;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final MemoryContent content() {
        return this.content;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryRecordCreateInput)) {
            return false;
        }
        MemoryRecordCreateInput other = (MemoryRecordCreateInput)obj;
        return Objects.equals(this.requestIdentifier(), other.requestIdentifier()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryRecordCreateInput").add("RequestIdentifier", (Object)this.requestIdentifier()).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("Content", (Object)this.content()).add("Timestamp", (Object)this.timestamp()).add("MemoryStrategyId", (Object)this.memoryStrategyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryRecordCreateInput, T> g) {
        return obj -> g.apply((MemoryRecordCreateInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestIdentifier;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private MemoryContent content;
        private Instant timestamp;
        private String memoryStrategyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryRecordCreateInput model) {
            this.requestIdentifier(model.requestIdentifier);
            this.namespaces(model.namespaces);
            this.content(model.content);
            this.timestamp(model.timestamp);
            this.memoryStrategyId(model.memoryStrategyId);
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final MemoryContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MemoryContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MemoryContent content) {
            this.content = content;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public MemoryRecordCreateInput build() {
            return new MemoryRecordCreateInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryRecordCreateInput> {
        public Builder requestIdentifier(String var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder content(MemoryContent var1);

        default public Builder content(Consumer<MemoryContent.Builder> content) {
            return this.content((MemoryContent)((MemoryContent.Builder)MemoryContent.builder().applyMutation(content)).build());
        }

        public Builder timestamp(Instant var1);

        public Builder memoryStrategyId(String var1);
    }
}

