/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMemoryRecordsRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, ListMemoryRecordsRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(ListMemoryRecordsRequest.getter(ListMemoryRecordsRequest::memoryId)).setter(ListMemoryRecordsRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListMemoryRecordsRequest.getter(ListMemoryRecordsRequest::namespace)).setter(ListMemoryRecordsRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryStrategyId").getter(ListMemoryRecordsRequest.getter(ListMemoryRecordsRequest::memoryStrategyId)).setter(ListMemoryRecordsRequest.setter(Builder::memoryStrategyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListMemoryRecordsRequest.getter(ListMemoryRecordsRequest::maxResults)).setter(ListMemoryRecordsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMemoryRecordsRequest.getter(ListMemoryRecordsRequest::nextToken)).setter(ListMemoryRecordsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, NAMESPACE_FIELD, MEMORY_STRATEGY_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMemoryRecordsRequest.memberNameToFieldInitializer();
    private final String memoryId;
    private final String namespace;
    private final String memoryStrategyId;
    private final Integer maxResults;
    private final String nextToken;

    private ListMemoryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.namespace = builder.namespace;
        this.memoryStrategyId = builder.memoryStrategyId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String memoryStrategyId() {
        return this.memoryStrategyId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemoryRecordsRequest)) {
            return false;
        }
        ListMemoryRecordsRequest other = (ListMemoryRecordsRequest)((Object)obj);
        return Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.memoryStrategyId(), other.memoryStrategyId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMemoryRecordsRequest").add("MemoryId", (Object)this.memoryId()).add("Namespace", (Object)this.namespace()).add("MemoryStrategyId", (Object)this.memoryStrategyId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "memoryStrategyId": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategyId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMemoryRecordsRequest, T> g) {
        return obj -> g.apply((ListMemoryRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String memoryId;
        private String namespace;
        private String memoryStrategyId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemoryRecordsRequest model) {
            super(model);
            this.memoryId(model.memoryId);
            this.namespace(model.namespace);
            this.memoryStrategyId(model.memoryStrategyId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getMemoryStrategyId() {
            return this.memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMemoryRecordsRequest build() {
            return new ListMemoryRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMemoryRecordsRequest> {
        public Builder memoryId(String var1);

        public Builder namespace(String var1);

        public Builder memoryStrategyId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

