/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import software.amazon.awssdk.awscore.eventstream.RestEventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.SdkPojoBuilder;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.AttachHttpMetadataResponseHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.protocol.VoidSdkResponse;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreAsyncClient;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreServiceClientConfiguration;
import software.amazon.awssdk.services.bedrockagentcore.internal.BedrockAgentCoreServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.bedrockagentcore.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreException;
import software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterStreamOutput;
import software.amazon.awssdk.services.bedrockagentcore.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.CreateEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.DeleteMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetEventResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetMemoryRecordResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceApiKeyResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetResourceOauth2TokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForJwtResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenForUserIdResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.GetWorkloadAccessTokenResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentcore.model.InvalidInputException;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterResponseHandler;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListBrowserSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListCodeInterpreterSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListEventsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.RuntimeClientErrorException;
import software.amazon.awssdk.services.bedrockagentcore.model.ServiceException;
import software.amazon.awssdk.services.bedrockagentcore.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StartCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopBrowserSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.StopCodeInterpreterSessionResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ThrottledException;
import software.amazon.awssdk.services.bedrockagentcore.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentcore.model.UnauthorizedException;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.UpdateBrowserStreamResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentcore.transform.CreateEventRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.DeleteEventRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.DeleteMemoryRecordRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetBrowserSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetCodeInterpreterSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetEventRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetMemoryRecordRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetResourceApiKeyRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetResourceOauth2TokenRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetWorkloadAccessTokenForJwtRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetWorkloadAccessTokenForUserIdRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.GetWorkloadAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.InvokeAgentRuntimeRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.InvokeCodeInterpreterRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListActorsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListBrowserSessionsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListCodeInterpreterSessionsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListEventsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListMemoryRecordsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.RetrieveMemoryRecordsRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.StartBrowserSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.StartCodeInterpreterSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.StopBrowserSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.StopCodeInterpreterSessionRequestMarshaller;
import software.amazon.awssdk.services.bedrockagentcore.transform.UpdateBrowserStreamRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
final class DefaultBedrockAgentCoreAsyncClient
implements BedrockAgentCoreAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultBedrockAgentCoreAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Executor executor;

    protected DefaultBedrockAgentCoreAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Bedrock_AgentCore#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executor = (Executor)clientConfiguration.option((ClientOption)SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR);
    }

    @Override
    public CompletableFuture<CreateEventResponse> createEvent(CreateEventRequest createEventRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, createEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEventRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$createEvent$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$createEvent$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventResponse> deleteEvent(DeleteEventRequest deleteEventRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEventRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$deleteEvent$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$deleteEvent$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMemoryRecordResponse> deleteMemoryRecord(DeleteMemoryRecordRequest deleteMemoryRecordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMemoryRecordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, deleteMemoryRecordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMemoryRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMemoryRecordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMemoryRecord").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteMemoryRecordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMemoryRecordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$deleteMemoryRecord$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$deleteMemoryRecord$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBrowserSessionResponse> getBrowserSession(GetBrowserSessionRequest getBrowserSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBrowserSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getBrowserSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBrowserSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBrowserSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBrowserSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBrowserSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBrowserSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getBrowserSession$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getBrowserSession$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCodeInterpreterSessionResponse> getCodeInterpreterSession(GetCodeInterpreterSessionRequest getCodeInterpreterSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCodeInterpreterSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getCodeInterpreterSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCodeInterpreterSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCodeInterpreterSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCodeInterpreterSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCodeInterpreterSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCodeInterpreterSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getCodeInterpreterSession$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getCodeInterpreterSession$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEventResponse> getEvent(GetEventRequest getEventRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEventRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getEvent$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getEvent$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMemoryRecordResponse> getMemoryRecord(GetMemoryRecordRequest getMemoryRecordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMemoryRecordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getMemoryRecordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMemoryRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMemoryRecordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMemoryRecord").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetMemoryRecordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMemoryRecordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getMemoryRecord$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getMemoryRecord$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceApiKeyResponse> getResourceApiKey(GetResourceApiKeyRequest getResourceApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceApiKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceApiKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceApiKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceApiKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getResourceApiKey$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getResourceApiKey$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceOauth2TokenResponse> getResourceOauth2Token(GetResourceOauth2TokenRequest getResourceOauth2TokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceOauth2TokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceOauth2TokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceOauth2Token");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceOauth2TokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceOauth2Token").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceOauth2TokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceOauth2TokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getResourceOauth2Token$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getResourceOauth2Token$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkloadAccessTokenResponse> getWorkloadAccessToken(GetWorkloadAccessTokenRequest getWorkloadAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkloadAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkloadAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkloadAccessToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkloadAccessTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkloadAccessToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkloadAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkloadAccessTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessToken$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessToken$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkloadAccessTokenForJwtResponse> getWorkloadAccessTokenForJWT(GetWorkloadAccessTokenForJwtRequest getWorkloadAccessTokenForJwtRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkloadAccessTokenForJwtRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkloadAccessTokenForJwtRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkloadAccessTokenForJWT");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkloadAccessTokenForJwtResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkloadAccessTokenForJWT").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkloadAccessTokenForJwtRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkloadAccessTokenForJwtRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessTokenForJWT$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessTokenForJWT$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkloadAccessTokenForUserIdResponse> getWorkloadAccessTokenForUserId(GetWorkloadAccessTokenForUserIdRequest getWorkloadAccessTokenForUserIdRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkloadAccessTokenForUserIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkloadAccessTokenForUserIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkloadAccessTokenForUserId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkloadAccessTokenForUserIdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkloadAccessTokenForUserId").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkloadAccessTokenForUserIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkloadAccessTokenForUserIdRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessTokenForUserId$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$getWorkloadAccessTokenForUserId$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> invokeAgentRuntime(InvokeAgentRuntimeRequest invokeAgentRuntimeRequest, AsyncResponseTransformer<InvokeAgentRuntimeResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)invokeAgentRuntimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, invokeAgentRuntimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InvokeAgentRuntime");
            Pair pair = AsyncResponseTransformerUtils.wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = (AsyncResponseTransformer)pair.left();
            CompletableFuture endOfStreamFuture = (CompletableFuture)pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InvokeAgentRuntimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvokeAgentRuntime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new InvokeAgentRuntimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withAsyncResponseTransformer(asyncResponseTransformer).withInput((SdkRequest)invokeAgentRuntimeRequest), asyncResponseTransformer);
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$invokeAgentRuntime$52(finalAsyncResponseTransformer, endOfStreamFuture, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$invokeAgentRuntime$54((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<Void> invokeCodeInterpreter(InvokeCodeInterpreterRequest invokeCodeInterpreterRequest, InvokeCodeInterpreterResponseHandler asyncResponseHandler) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)invokeCodeInterpreterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, invokeCodeInterpreterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InvokeCodeInterpreter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            AttachHttpMetadataResponseHandler responseHandler = new AttachHttpMetadataResponseHandler(this.protocolFactory.createResponseHandler(operationMetadata, InvokeCodeInterpreterResponse::builder));
            HttpResponseHandler voidResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(false).hasStreamingSuccessResponse(true).build(), VoidSdkResponse::builder);
            HttpResponseHandler eventResponseHandler = this.protocolFactory.createResponseHandler(JsonOperationMetadata.builder().isPayloadJson(true).hasStreamingSuccessResponse(false).build(), (Function)EventStreamTaggedUnionPojoSupplier.builder().putSdkPojoSupplier("result", CodeInterpreterStreamOutput::resultBuilder).defaultSdkPojoSupplier(() -> new SdkPojoBuilder((SdkPojo)CodeInterpreterStreamOutput.UNKNOWN)).build());
            Function<String, Optional<ExceptionMetadata>> eventstreamExceptionMetadataMapper = errorCode -> {
                switch (errorCode) {
                    case "accessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "conflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "internalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "resourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "serviceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "throttlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "validationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorEventResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, eventstreamExceptionMetadataMapper);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture future = new CompletableFuture();
            EventStreamAsyncResponseTransformer asyncResponseTransformer = EventStreamAsyncResponseTransformer.builder().eventStreamResponseHandler((EventStreamResponseHandler)asyncResponseHandler).eventResponseHandler(eventResponseHandler).initialResponseHandler((HttpResponseHandler)responseHandler).exceptionResponseHandler(errorEventResponseHandler).future(future).executor(this.executor).serviceName(this.serviceName()).build();
            RestEventStreamAsyncResponseTransformer restAsyncResponseTransformer = RestEventStreamAsyncResponseTransformer.builder().eventStreamAsyncResponseTransformer(asyncResponseTransformer).eventStreamResponseHandler((EventStreamResponseHandler)asyncResponseHandler).build();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvokeCodeInterpreter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new InvokeCodeInterpreterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)invokeCodeInterpreterRequest), (AsyncResponseTransformer)restAsyncResponseTransformer);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$invokeCodeInterpreter$59(asyncResponseHandler, future, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return CompletableFutureUtils.forwardExceptionTo(future, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseHandler.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$invokeCodeInterpreter$61((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListActorsResponse> listActors(ListActorsRequest listActorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listActorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListActorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listActorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listActors$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listActors$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBrowserSessionsResponse> listBrowserSessions(ListBrowserSessionsRequest listBrowserSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBrowserSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listBrowserSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBrowserSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBrowserSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBrowserSessions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBrowserSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBrowserSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listBrowserSessions$68(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listBrowserSessions$69((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCodeInterpreterSessionsResponse> listCodeInterpreterSessions(ListCodeInterpreterSessionsRequest listCodeInterpreterSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCodeInterpreterSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listCodeInterpreterSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCodeInterpreterSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCodeInterpreterSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCodeInterpreterSessions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCodeInterpreterSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCodeInterpreterSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listCodeInterpreterSessions$72(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listCodeInterpreterSessions$73((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEventsResponse> listEvents(ListEventsRequest listEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listEvents$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listEvents$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMemoryRecordsResponse> listMemoryRecords(ListMemoryRecordsRequest listMemoryRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMemoryRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listMemoryRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMemoryRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMemoryRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMemoryRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListMemoryRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMemoryRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listMemoryRecords$80(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listMemoryRecords$81((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, listSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSessions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$listSessions$84(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$listSessions$85((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetrieveMemoryRecordsResponse> retrieveMemoryRecords(RetrieveMemoryRecordsRequest retrieveMemoryRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retrieveMemoryRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, retrieveMemoryRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetrieveMemoryRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetrieveMemoryRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveMemoryRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RetrieveMemoryRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retrieveMemoryRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$retrieveMemoryRecords$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$retrieveMemoryRecords$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartBrowserSessionResponse> startBrowserSession(StartBrowserSessionRequest startBrowserSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startBrowserSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, startBrowserSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartBrowserSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBrowserSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBrowserSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartBrowserSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startBrowserSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$startBrowserSession$92(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$startBrowserSession$93((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartCodeInterpreterSessionResponse> startCodeInterpreterSession(StartCodeInterpreterSessionRequest startCodeInterpreterSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCodeInterpreterSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, startCodeInterpreterSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCodeInterpreterSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCodeInterpreterSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCodeInterpreterSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartCodeInterpreterSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCodeInterpreterSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$startCodeInterpreterSession$96(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$startCodeInterpreterSession$97((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopBrowserSessionResponse> stopBrowserSession(StopBrowserSessionRequest stopBrowserSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopBrowserSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, stopBrowserSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopBrowserSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopBrowserSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopBrowserSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopBrowserSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopBrowserSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$stopBrowserSession$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$stopBrowserSession$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopCodeInterpreterSessionResponse> stopCodeInterpreterSession(StopCodeInterpreterSessionRequest stopCodeInterpreterSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopCodeInterpreterSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, stopCodeInterpreterSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopCodeInterpreterSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCodeInterpreterSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCodeInterpreterSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopCodeInterpreterSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopCodeInterpreterSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$stopCodeInterpreterSession$104(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$stopCodeInterpreterSession$105((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBrowserStreamResponse> updateBrowserStream(UpdateBrowserStreamRequest updateBrowserStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBrowserStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBedrockAgentCoreAsyncClient.resolveMetricPublishers(clientConfiguration, updateBrowserStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Bedrock AgentCore");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBrowserStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBrowserStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "RuntimeClientError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RuntimeClientError").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(RuntimeClientErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBrowserStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBrowserStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBrowserStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultBedrockAgentCoreAsyncClient.lambda$updateBrowserStream$108(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultBedrockAgentCoreAsyncClient.lambda$updateBrowserStream$109((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final BedrockAgentCoreServiceClientConfiguration serviceClientConfiguration() {
        return new BedrockAgentCoreServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "bedrock-agentcore";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BedrockAgentCoreException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BedrockAgentCoreServiceClientConfigurationBuilder serviceConfigBuilder = new BedrockAgentCoreServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateBrowserStream$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBrowserStream$108(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBrowserStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopCodeInterpreterSession$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopCodeInterpreterSession$104(List metricPublishers, MetricCollector apiCallMetricCollector, StopCodeInterpreterSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopBrowserSession$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopBrowserSession$100(List metricPublishers, MetricCollector apiCallMetricCollector, StopBrowserSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCodeInterpreterSession$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCodeInterpreterSession$96(List metricPublishers, MetricCollector apiCallMetricCollector, StartCodeInterpreterSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startBrowserSession$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startBrowserSession$92(List metricPublishers, MetricCollector apiCallMetricCollector, StartBrowserSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retrieveMemoryRecords$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retrieveMemoryRecords$88(List metricPublishers, MetricCollector apiCallMetricCollector, RetrieveMemoryRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSessions$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSessions$84(List metricPublishers, MetricCollector apiCallMetricCollector, ListSessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMemoryRecords$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMemoryRecords$80(List metricPublishers, MetricCollector apiCallMetricCollector, ListMemoryRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEvents$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEvents$76(List metricPublishers, MetricCollector apiCallMetricCollector, ListEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCodeInterpreterSessions$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCodeInterpreterSessions$72(List metricPublishers, MetricCollector apiCallMetricCollector, ListCodeInterpreterSessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBrowserSessions$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBrowserSessions$68(List metricPublishers, MetricCollector apiCallMetricCollector, ListBrowserSessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listActors$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActors$64(List metricPublishers, MetricCollector apiCallMetricCollector, ListActorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$invokeCodeInterpreter$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$invokeCodeInterpreter$59(InvokeCodeInterpreterResponseHandler asyncResponseHandler, CompletableFuture future, List metricPublishers, MetricCollector apiCallMetricCollector, Void r, Throwable e) {
        if (e != null) {
            try {
                asyncResponseHandler.exceptionOccurred(e);
            }
            finally {
                future.completeExceptionally(e);
            }
        }
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$invokeAgentRuntime$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$invokeAgentRuntime$52(AsyncResponseTransformer finalAsyncResponseTransformer, CompletableFuture endOfStreamFuture, List metricPublishers, MetricCollector apiCallMetricCollector, Object r, Throwable e) {
        if (e != null) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(e));
        }
        endOfStreamFuture.whenComplete((r2, e2) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
    }

    private static /* synthetic */ void lambda$getWorkloadAccessTokenForUserId$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkloadAccessTokenForUserId$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkloadAccessTokenForUserIdResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkloadAccessTokenForJWT$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkloadAccessTokenForJWT$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkloadAccessTokenForJwtResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkloadAccessToken$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkloadAccessToken$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkloadAccessTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceOauth2Token$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceOauth2Token$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceOauth2TokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceApiKey$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceApiKey$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceApiKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMemoryRecord$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMemoryRecord$26(List metricPublishers, MetricCollector apiCallMetricCollector, GetMemoryRecordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEvent$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEvent$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetEventResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCodeInterpreterSession$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCodeInterpreterSession$18(List metricPublishers, MetricCollector apiCallMetricCollector, GetCodeInterpreterSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBrowserSession$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBrowserSession$14(List metricPublishers, MetricCollector apiCallMetricCollector, GetBrowserSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMemoryRecord$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMemoryRecord$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMemoryRecordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEvent$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEvent$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEventResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEvent$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEvent$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEventResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

