/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Oauth2FlowType {
    USER_FEDERATION("USER_FEDERATION"),
    M2_M("M2M"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Oauth2FlowType> VALUE_MAP;
    private final String value;

    private Oauth2FlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Oauth2FlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Oauth2FlowType> knownValues() {
        EnumSet<Oauth2FlowType> knownValues = EnumSet.allOf(Oauth2FlowType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Oauth2FlowType.class, Oauth2FlowType::toString);
    }
}

