/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlock;
import software.amazon.awssdk.services.bedrockagentcore.model.InputContentBlockListCopier;
import software.amazon.awssdk.services.bedrockagentcore.model.ProgrammingLanguage;
import software.amazon.awssdk.services.bedrockagentcore.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolArguments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolArguments> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(ToolArguments.getter(ToolArguments::code)).setter(ToolArguments.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(ToolArguments.getter(ToolArguments::languageAsString)).setter(ToolArguments.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<Boolean> CLEAR_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("clearContext").getter(ToolArguments.getter(ToolArguments::clearContext)).setter(ToolArguments.setter(Builder::clearContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearContext").build()}).build();
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(ToolArguments.getter(ToolArguments::command)).setter(ToolArguments.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(ToolArguments.getter(ToolArguments::path)).setter(ToolArguments.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("paths").getter(ToolArguments.getter(ToolArguments::paths)).setter(ToolArguments.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(ToolArguments.getter(ToolArguments::content)).setter(ToolArguments.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directoryPath").getter(ToolArguments.getter(ToolArguments::directoryPath)).setter(ToolArguments.setter(Builder::directoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryPath").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(ToolArguments.getter(ToolArguments::taskId)).setter(ToolArguments.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, LANGUAGE_FIELD, CLEAR_CONTEXT_FIELD, COMMAND_FIELD, PATH_FIELD, PATHS_FIELD, CONTENT_FIELD, DIRECTORY_PATH_FIELD, TASK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolArguments.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String language;
    private final Boolean clearContext;
    private final String command;
    private final String path;
    private final List<String> paths;
    private final List<InputContentBlock> content;
    private final String directoryPath;
    private final String taskId;

    private ToolArguments(BuilderImpl builder) {
        this.code = builder.code;
        this.language = builder.language;
        this.clearContext = builder.clearContext;
        this.command = builder.command;
        this.path = builder.path;
        this.paths = builder.paths;
        this.content = builder.content;
        this.directoryPath = builder.directoryPath;
        this.taskId = builder.taskId;
    }

    public final String code() {
        return this.code;
    }

    public final ProgrammingLanguage language() {
        return ProgrammingLanguage.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final Boolean clearContext() {
        return this.clearContext;
    }

    public final String command() {
        return this.command;
    }

    public final String path() {
        return this.path;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<InputContentBlock> content() {
        return this.content;
    }

    public final String directoryPath() {
        return this.directoryPath;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clearContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolArguments)) {
            return false;
        }
        ToolArguments other = (ToolArguments)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.clearContext(), other.clearContext()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.path(), other.path()) && this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && Objects.equals(this.directoryPath(), other.directoryPath()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"ToolArguments").add("Code", (Object)this.code()).add("Language", (Object)this.languageAsString()).add("ClearContext", (Object)this.clearContext()).add("Command", (Object)this.command()).add("Path", (Object)this.path()).add("Paths", this.hasPaths() ? this.paths() : null).add("Content", this.hasContent() ? this.content() : null).add("DirectoryPath", (Object)this.directoryPath()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "clearContext": {
                return Optional.ofNullable(clazz.cast(this.clearContext()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "directoryPath": {
                return Optional.ofNullable(clazz.cast(this.directoryPath()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", CODE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("clearContext", CLEAR_CONTEXT_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("path", PATH_FIELD);
        map.put("paths", PATHS_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("directoryPath", DIRECTORY_PATH_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolArguments, T> g) {
        return obj -> g.apply((ToolArguments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String language;
        private Boolean clearContext;
        private String command;
        private String path;
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private List<InputContentBlock> content = DefaultSdkAutoConstructList.getInstance();
        private String directoryPath;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolArguments model) {
            this.code(model.code);
            this.language(model.language);
            this.clearContext(model.clearContext);
            this.command(model.command);
            this.path(model.path);
            this.paths(model.paths);
            this.content(model.content);
            this.directoryPath(model.directoryPath);
            this.taskId(model.taskId);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(ProgrammingLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Boolean getClearContext() {
            return this.clearContext;
        }

        public final void setClearContext(Boolean clearContext) {
            this.clearContext = clearContext;
        }

        @Override
        public final Builder clearContext(Boolean clearContext) {
            this.clearContext = clearContext;
            return this;
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = StringListCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = StringListCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final List<InputContentBlock.Builder> getContent() {
            List<InputContentBlock.Builder> result = InputContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InputContentBlock.BuilderImpl> content) {
            this.content = InputContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<InputContentBlock> content) {
            this.content = InputContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(InputContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<InputContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (InputContentBlock)((InputContentBlock.Builder)InputContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDirectoryPath() {
            return this.directoryPath;
        }

        public final void setDirectoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
        }

        @Override
        public final Builder directoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public ToolArguments build() {
            return new ToolArguments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolArguments> {
        public Builder code(String var1);

        public Builder language(String var1);

        public Builder language(ProgrammingLanguage var1);

        public Builder clearContext(Boolean var1);

        public Builder command(String var1);

        public Builder path(String var1);

        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder content(Collection<InputContentBlock> var1);

        public Builder content(InputContentBlock ... var1);

        public Builder content(Consumer<InputContentBlock.Builder> ... var1);

        public Builder directoryPath(String var1);

        public Builder taskId(String var1);
    }
}

