/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProgrammingLanguage {
    PYTHON("python"),
    JAVASCRIPT("javascript"),
    TYPESCRIPT("typescript"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProgrammingLanguage> VALUE_MAP;
    private final String value;

    private ProgrammingLanguage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProgrammingLanguage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProgrammingLanguage> knownValues() {
        EnumSet<ProgrammingLanguage> knownValues = EnumSet.allOf(ProgrammingLanguage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProgrammingLanguage.class, ProgrammingLanguage::toString);
    }
}

