/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListMemoryRecordsResponse;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary;

public class ListMemoryRecordsIterable
implements SdkIterable<ListMemoryRecordsResponse> {
    private final BedrockAgentCoreClient client;
    private final ListMemoryRecordsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMemoryRecordsIterable(BedrockAgentCoreClient client, ListMemoryRecordsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMemoryRecordsResponseFetcher();
    }

    public Iterator<ListMemoryRecordsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MemoryRecordSummary> memoryRecordSummaries() {
        Function<ListMemoryRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memoryRecordSummaries() != null) {
                return response.memoryRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMemoryRecordsResponseFetcher
    implements SyncPageFetcher<ListMemoryRecordsResponse> {
        private ListMemoryRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoryRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMemoryRecordsResponse nextPage(ListMemoryRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListMemoryRecordsIterable.this.client.listMemoryRecords(ListMemoryRecordsIterable.this.firstRequest);
            }
            return ListMemoryRecordsIterable.this.client.listMemoryRecords((ListMemoryRecordsRequest)((Object)ListMemoryRecordsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

