/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceApiKeyRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, GetResourceApiKeyRequest> {
    private static final SdkField<String> WORKLOAD_IDENTITY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadIdentityToken").getter(GetResourceApiKeyRequest.getter(GetResourceApiKeyRequest::workloadIdentityToken)).setter(GetResourceApiKeyRequest.setter(Builder::workloadIdentityToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityToken").build()}).build();
    private static final SdkField<String> RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceCredentialProviderName").getter(GetResourceApiKeyRequest.getter(GetResourceApiKeyRequest::resourceCredentialProviderName)).setter(GetResourceApiKeyRequest.setter(Builder::resourceCredentialProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCredentialProviderName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_IDENTITY_TOKEN_FIELD, RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceApiKeyRequest.memberNameToFieldInitializer();
    private final String workloadIdentityToken;
    private final String resourceCredentialProviderName;

    private GetResourceApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.workloadIdentityToken = builder.workloadIdentityToken;
        this.resourceCredentialProviderName = builder.resourceCredentialProviderName;
    }

    public final String workloadIdentityToken() {
        return this.workloadIdentityToken;
    }

    public final String resourceCredentialProviderName() {
        return this.resourceCredentialProviderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCredentialProviderName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceApiKeyRequest)) {
            return false;
        }
        GetResourceApiKeyRequest other = (GetResourceApiKeyRequest)((Object)obj);
        return Objects.equals(this.workloadIdentityToken(), other.workloadIdentityToken()) && Objects.equals(this.resourceCredentialProviderName(), other.resourceCredentialProviderName());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceApiKeyRequest").add("WorkloadIdentityToken", (Object)(this.workloadIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourceCredentialProviderName", (Object)this.resourceCredentialProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workloadIdentityToken": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentityToken()));
            }
            case "resourceCredentialProviderName": {
                return Optional.ofNullable(clazz.cast(this.resourceCredentialProviderName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("workloadIdentityToken", WORKLOAD_IDENTITY_TOKEN_FIELD);
        map.put("resourceCredentialProviderName", RESOURCE_CREDENTIAL_PROVIDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceApiKeyRequest, T> g) {
        return obj -> g.apply((GetResourceApiKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String workloadIdentityToken;
        private String resourceCredentialProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceApiKeyRequest model) {
            super(model);
            this.workloadIdentityToken(model.workloadIdentityToken);
            this.resourceCredentialProviderName(model.resourceCredentialProviderName);
        }

        public final String getWorkloadIdentityToken() {
            return this.workloadIdentityToken;
        }

        public final void setWorkloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
        }

        @Override
        public final Builder workloadIdentityToken(String workloadIdentityToken) {
            this.workloadIdentityToken = workloadIdentityToken;
            return this;
        }

        public final String getResourceCredentialProviderName() {
            return this.resourceCredentialProviderName;
        }

        public final void setResourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
        }

        @Override
        public final Builder resourceCredentialProviderName(String resourceCredentialProviderName) {
            this.resourceCredentialProviderName = resourceCredentialProviderName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceApiKeyRequest build() {
            return new GetResourceApiKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceApiKeyRequest> {
        public Builder workloadIdentityToken(String var1);

        public Builder resourceCredentialProviderName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

