/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an update to a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamUpdate implements SdkPojo, Serializable, ToCopyableBuilder<StreamUpdate.Builder, StreamUpdate> {
    private static final SdkField<AutomationStreamUpdate> AUTOMATION_STREAM_UPDATE_FIELD = SdkField
            .<AutomationStreamUpdate> builder(MarshallingType.SDK_POJO).memberName("automationStreamUpdate")
            .getter(getter(StreamUpdate::automationStreamUpdate)).setter(setter(Builder::automationStreamUpdate))
            .constructor(AutomationStreamUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationStreamUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTOMATION_STREAM_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomationStreamUpdate automationStreamUpdate;

    private final Type type;

    private StreamUpdate(BuilderImpl builder) {
        this.automationStreamUpdate = builder.automationStreamUpdate;
        this.type = builder.type;
    }

    /**
     * <p>
     * The update to an automation stream.
     * </p>
     * 
     * @return The update to an automation stream.
     */
    public final AutomationStreamUpdate automationStreamUpdate() {
        return automationStreamUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationStreamUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamUpdate)) {
            return false;
        }
        StreamUpdate other = (StreamUpdate) obj;
        return Objects.equals(automationStreamUpdate(), other.automationStreamUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamUpdate").add("AutomationStreamUpdate", automationStreamUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automationStreamUpdate":
            return Optional.ofNullable(clazz.cast(automationStreamUpdate()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #automationStreamUpdate()} initialized to the given value.
     *
     * <p>
     * The update to an automation stream.
     * </p>
     * 
     * @param automationStreamUpdate
     *        The update to an automation stream.
     */
    public static StreamUpdate fromAutomationStreamUpdate(AutomationStreamUpdate automationStreamUpdate) {
        return builder().automationStreamUpdate(automationStreamUpdate).build();
    }

    /**
     * Create an instance of this class with {@link #automationStreamUpdate()} initialized to the given value.
     *
     * <p>
     * The update to an automation stream.
     * </p>
     * 
     * @param automationStreamUpdate
     *        The update to an automation stream.
     */
    public static StreamUpdate fromAutomationStreamUpdate(Consumer<AutomationStreamUpdate.Builder> automationStreamUpdate) {
        AutomationStreamUpdate.Builder builder = AutomationStreamUpdate.builder();
        automationStreamUpdate.accept(builder);
        return fromAutomationStreamUpdate(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automationStreamUpdate", AUTOMATION_STREAM_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamUpdate, T> g) {
        return obj -> g.apply((StreamUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamUpdate> {
        /**
         * <p>
         * The update to an automation stream.
         * </p>
         * 
         * @param automationStreamUpdate
         *        The update to an automation stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationStreamUpdate(AutomationStreamUpdate automationStreamUpdate);

        /**
         * <p>
         * The update to an automation stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomationStreamUpdate.Builder} avoiding
         * the need to create one manually via {@link AutomationStreamUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationStreamUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #automationStreamUpdate(AutomationStreamUpdate)}.
         * 
         * @param automationStreamUpdate
         *        a consumer that will call methods on {@link AutomationStreamUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationStreamUpdate(AutomationStreamUpdate)
         */
        default Builder automationStreamUpdate(Consumer<AutomationStreamUpdate.Builder> automationStreamUpdate) {
            return automationStreamUpdate(AutomationStreamUpdate.builder().applyMutation(automationStreamUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomationStreamUpdate automationStreamUpdate;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StreamUpdate model) {
            automationStreamUpdate(model.automationStreamUpdate);
        }

        public final AutomationStreamUpdate.Builder getAutomationStreamUpdate() {
            return automationStreamUpdate != null ? automationStreamUpdate.toBuilder() : null;
        }

        public final void setAutomationStreamUpdate(AutomationStreamUpdate.BuilderImpl automationStreamUpdate) {
            Object oldValue = this.automationStreamUpdate;
            this.automationStreamUpdate = automationStreamUpdate != null ? automationStreamUpdate.build() : null;
            handleUnionValueChange(Type.AUTOMATION_STREAM_UPDATE, oldValue, this.automationStreamUpdate);
        }

        @Override
        public final Builder automationStreamUpdate(AutomationStreamUpdate automationStreamUpdate) {
            Object oldValue = this.automationStreamUpdate;
            this.automationStreamUpdate = automationStreamUpdate;
            handleUnionValueChange(Type.AUTOMATION_STREAM_UPDATE, oldValue, this.automationStreamUpdate);
            return this;
        }

        @Override
        public StreamUpdate build() {
            return new StreamUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StreamUpdate#type()
     */
    public enum Type {
        AUTOMATION_STREAM_UPDATE,

        UNKNOWN_TO_SDK_VERSION
    }
}
