/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkloadAccessTokenResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<GetWorkloadAccessTokenResponse.Builder, GetWorkloadAccessTokenResponse> {
    private static final SdkField<String> WORKLOAD_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadAccessToken").getter(getter(GetWorkloadAccessTokenResponse::workloadAccessToken))
            .setter(setter(Builder::workloadAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadAccessToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadAccessToken;

    private GetWorkloadAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.workloadAccessToken = builder.workloadAccessToken;
    }

    /**
     * <p>
     * Opaque token representing both agent and user identity
     * </p>
     * 
     * @return Opaque token representing both agent and user identity
     */
    public final String workloadAccessToken() {
        return workloadAccessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadAccessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkloadAccessTokenResponse)) {
            return false;
        }
        GetWorkloadAccessTokenResponse other = (GetWorkloadAccessTokenResponse) obj;
        return Objects.equals(workloadAccessToken(), other.workloadAccessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkloadAccessTokenResponse")
                .add("WorkloadAccessToken", workloadAccessToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadAccessToken":
            return Optional.ofNullable(clazz.cast(workloadAccessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workloadAccessToken", WORKLOAD_ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkloadAccessTokenResponse, T> g) {
        return obj -> g.apply((GetWorkloadAccessTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkloadAccessTokenResponse> {
        /**
         * <p>
         * Opaque token representing both agent and user identity
         * </p>
         * 
         * @param workloadAccessToken
         *        Opaque token representing both agent and user identity
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadAccessToken(String workloadAccessToken);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String workloadAccessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkloadAccessTokenResponse model) {
            super(model);
            workloadAccessToken(model.workloadAccessToken);
        }

        public final String getWorkloadAccessToken() {
            return workloadAccessToken;
        }

        public final void setWorkloadAccessToken(String workloadAccessToken) {
            this.workloadAccessToken = workloadAccessToken;
        }

        @Override
        public final Builder workloadAccessToken(String workloadAccessToken) {
            this.workloadAccessToken = workloadAccessToken;
            return this;
        }

        @Override
        public GetWorkloadAccessTokenResponse build() {
            return new GetWorkloadAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
