/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopCodeInterpreterSessionResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<StopCodeInterpreterSessionResponse.Builder, StopCodeInterpreterSessionResponse> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterIdentifier")
            .getter(getter(StopCodeInterpreterSessionResponse::codeInterpreterIdentifier))
            .setter(setter(Builder::codeInterpreterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterIdentifier").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(StopCodeInterpreterSessionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(StopCodeInterpreterSessionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterIdentifier;

    private final String sessionId;

    private final Instant lastUpdatedAt;

    private StopCodeInterpreterSessionResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The identifier of the code interpreter.
     * </p>
     * 
     * @return The identifier of the code interpreter.
     */
    public final String codeInterpreterIdentifier() {
        return codeInterpreterIdentifier;
    }

    /**
     * <p>
     * The identifier of the code interpreter session.
     * </p>
     * 
     * @return The identifier of the code interpreter session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The timestamp when the code interpreter session was last updated.
     * </p>
     * 
     * @return The timestamp when the code interpreter session was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopCodeInterpreterSessionResponse)) {
            return false;
        }
        StopCodeInterpreterSessionResponse other = (StopCodeInterpreterSessionResponse) obj;
        return Objects.equals(codeInterpreterIdentifier(), other.codeInterpreterIdentifier())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopCodeInterpreterSessionResponse")
                .add("CodeInterpreterIdentifier", codeInterpreterIdentifier()).add("SessionId", sessionId())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterIdentifier":
            return Optional.ofNullable(clazz.cast(codeInterpreterIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopCodeInterpreterSessionResponse, T> g) {
        return obj -> g.apply((StopCodeInterpreterSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopCodeInterpreterSessionResponse> {
        /**
         * <p>
         * The identifier of the code interpreter.
         * </p>
         * 
         * @param codeInterpreterIdentifier
         *        The identifier of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterIdentifier(String codeInterpreterIdentifier);

        /**
         * <p>
         * The identifier of the code interpreter session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the code interpreter session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The timestamp when the code interpreter session was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the code interpreter session was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String codeInterpreterIdentifier;

        private String sessionId;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StopCodeInterpreterSessionResponse model) {
            super(model);
            codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            sessionId(model.sessionId);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getCodeInterpreterIdentifier() {
            return codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public StopCodeInterpreterSessionResponse build() {
            return new StopCodeInterpreterSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
