/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model.codeinterpreterstreamoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterResult;
import software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterStreamOutput;
import software.amazon.awssdk.services.bedrockagentcore.model.InvokeCodeInterpreterResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterResult} that
 * represents the {@code CodeInterpreterStreamOutput$result} event. Do not use this class directly. Instead, use the
 * static builder methods on {@link software.amazon.awssdk.services.bedrockagentcore.model.CodeInterpreterStreamOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultResult extends CodeInterpreterResult {
    private static final long serialVersionUID = 1L;

    DefaultResult(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeCodeInterpreterResponseHandler.Visitor visitor) {
        visitor.visitResult(this);
    }

    @Override
    public CodeInterpreterStreamOutput.EventType sdkEventType() {
        return CodeInterpreterStreamOutput.EventType.RESULT;
    }

    public interface Builder extends CodeInterpreterResult.Builder {
        @Override
        DefaultResult build();
    }

    private static final class BuilderImpl extends CodeInterpreterResult.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultResult event) {
            super(event);
        }

        @Override
        public DefaultResult build() {
            return new DefaultResult(this);
        }
    }
}
