/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<DeleteEventRequest.Builder, DeleteEventRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(DeleteEventRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(DeleteEventRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(DeleteEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("eventId").build()).build();

    private static final SdkField<String> ACTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actorId").getter(getter(DeleteEventRequest::actorId)).setter(setter(Builder::actorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD,
            SESSION_ID_FIELD, EVENT_ID_FIELD, ACTOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String memoryId;

    private final String sessionId;

    private final String eventId;

    private final String actorId;

    private DeleteEventRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.sessionId = builder.sessionId;
        this.eventId = builder.eventId;
        this.actorId = builder.actorId;
    }

    /**
     * <p>
     * The identifier of the AgentCore Memory resource from which to delete the event.
     * </p>
     * 
     * @return The identifier of the AgentCore Memory resource from which to delete the event.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The identifier of the session containing the event to delete.
     * </p>
     * 
     * @return The identifier of the session containing the event to delete.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The identifier of the event to delete.
     * </p>
     * 
     * @return The identifier of the event to delete.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The identifier of the actor associated with the event to delete.
     * </p>
     * 
     * @return The identifier of the actor associated with the event to delete.
     */
    public final String actorId() {
        return actorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(actorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventRequest)) {
            return false;
        }
        DeleteEventRequest other = (DeleteEventRequest) obj;
        return Objects.equals(memoryId(), other.memoryId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(actorId(), other.actorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEventRequest").add("MemoryId", memoryId()).add("SessionId", sessionId())
                .add("EventId", eventId()).add("ActorId", actorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "actorId":
            return Optional.ofNullable(clazz.cast(actorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("actorId", ACTOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventRequest, T> g) {
        return obj -> g.apply((DeleteEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEventRequest> {
        /**
         * <p>
         * The identifier of the AgentCore Memory resource from which to delete the event.
         * </p>
         * 
         * @param memoryId
         *        The identifier of the AgentCore Memory resource from which to delete the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The identifier of the session containing the event to delete.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session containing the event to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The identifier of the event to delete.
         * </p>
         * 
         * @param eventId
         *        The identifier of the event to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The identifier of the actor associated with the event to delete.
         * </p>
         * 
         * @param actorId
         *        The identifier of the actor associated with the event to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actorId(String actorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String memoryId;

        private String sessionId;

        private String eventId;

        private String actorId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventRequest model) {
            super(model);
            memoryId(model.memoryId);
            sessionId(model.sessionId);
            eventId(model.eventId);
            actorId(model.actorId);
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getActorId() {
            return actorId;
        }

        public final void setActorId(String actorId) {
            this.actorId = actorId;
        }

        @Override
        public final Builder actorId(String actorId) {
            this.actorId = actorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEventRequest build() {
            return new DeleteEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
