/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMemoryRecordRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, DeleteMemoryRecordRequest> {
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(DeleteMemoryRecordRequest.getter(DeleteMemoryRecordRequest::memoryId)).setter(DeleteMemoryRecordRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()}).build();
    private static final SdkField<String> MEMORY_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryRecordId").getter(DeleteMemoryRecordRequest.getter(DeleteMemoryRecordRequest::memoryRecordId)).setter(DeleteMemoryRecordRequest.setter(Builder::memoryRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryRecordId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_ID_FIELD, MEMORY_RECORD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteMemoryRecordRequest.memberNameToFieldInitializer();
    private final String memoryId;
    private final String memoryRecordId;

    private DeleteMemoryRecordRequest(BuilderImpl builder) {
        super(builder);
        this.memoryId = builder.memoryId;
        this.memoryRecordId = builder.memoryRecordId;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String memoryRecordId() {
        return this.memoryRecordId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryRecordId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMemoryRecordRequest)) {
            return false;
        }
        DeleteMemoryRecordRequest other = (DeleteMemoryRecordRequest)((Object)obj);
        return Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.memoryRecordId(), other.memoryRecordId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteMemoryRecordRequest").add("MemoryId", (Object)this.memoryId()).add("MemoryRecordId", (Object)this.memoryRecordId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "memoryRecordId": {
                return Optional.ofNullable(clazz.cast(this.memoryRecordId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("memoryRecordId", MEMORY_RECORD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMemoryRecordRequest, T> g) {
        return obj -> g.apply((DeleteMemoryRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String memoryId;
        private String memoryRecordId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMemoryRecordRequest model) {
            super(model);
            this.memoryId(model.memoryId);
            this.memoryRecordId(model.memoryRecordId);
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getMemoryRecordId() {
            return this.memoryRecordId;
        }

        public final void setMemoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
        }

        @Override
        public final Builder memoryRecordId(String memoryRecordId) {
            this.memoryRecordId = memoryRecordId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMemoryRecordRequest build() {
            return new DeleteMemoryRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMemoryRecordRequest> {
        public Builder memoryId(String var1);

        public Builder memoryRecordId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

