/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ToolName {
    EXECUTE_CODE("executeCode"),
    EXECUTE_COMMAND("executeCommand"),
    READ_FILES("readFiles"),
    LIST_FILES("listFiles"),
    REMOVE_FILES("removeFiles"),
    WRITE_FILES("writeFiles"),
    START_COMMAND_EXECUTION("startCommandExecution"),
    GET_TASK("getTask"),
    STOP_TASK("stopTask"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ToolName> VALUE_MAP;
    private final String value;

    private ToolName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ToolName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ToolName> knownValues() {
        EnumSet<ToolName> knownValues = EnumSet.allOf(ToolName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ToolName.class, ToolName::toString);
    }
}

